/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import java.util.Collections;
import org.apache.commons.math.complex.Complex;
import org.renjin.eval.EvalException;
import org.renjin.sexp.AbstractSEXP;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.Logical;
import org.renjin.sexp.PairList;
import org.renjin.sexp.PromisePairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;

public final class Null
extends AbstractSEXP
implements AtomicVector,
PairList,
PromisePairList {
    public static final String TYPE_NAME = "NULL";
    public static final Null INSTANCE = new Null();
    public static final Vector.Type VECTOR_TYPE = new NullType();
    private static final String INDEX_OUT_OF_BOUNDS = "The NULL object is zero-length.";
    private static final String NULL_IS_IMMUTABLE = "The NULL object is immutable";

    private Null() {
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public int length() {
        return 0;
    }

    @Override
    public String toString() {
        return TYPE_NAME;
    }

    @Override
    public void accept(SexpVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <S extends SEXP> S getElementAsSEXP(int i) {
        throw new IllegalArgumentException(INDEX_OUT_OF_BOUNDS);
    }

    @Override
    public Iterable<SEXP> values() {
        return Collections.emptySet();
    }

    @Override
    public Iterable<PairList.Node> nodes() {
        return Collections.emptySet();
    }

    @Override
    public Null toVector() {
        return this;
    }

    @Override
    public SEXP findByTag(Symbol symbol2) {
        return INSTANCE;
    }

    @Override
    public StringVector getS3Class() {
        return new StringArrayVector(TYPE_NAME);
    }

    @Override
    public boolean isWiderThan(Vector vector2) {
        return this.getVectorType().isWiderThan(vector2);
    }

    @Override
    public SEXP setAttributes(AttributeMap attributes2) {
        if (attributes2 != AttributeMap.EMPTY) {
            throw new EvalException("Attributes cannot be set on NULL", new Object[0]);
        }
        return this;
    }

    @Override
    public AttributeMap getAttributes() {
        return AttributeMap.EMPTY;
    }

    @Override
    public SEXP setAttribute(Symbol attributeName, SEXP value) {
        if (value == INSTANCE) {
            return this;
        }
        throw new EvalException("Attributes cannot be set on NULL", new Object[0]);
    }

    @Override
    public Null getAttribute(Symbol name) {
        return INSTANCE;
    }

    @Override
    public Null getNames() {
        return INSTANCE;
    }

    @Override
    public Vector.Builder newCopyBuilder() {
        return NullBuilder.INSTANCE;
    }

    @Override
    public Vector.Builder newCopyBuilder(Vector.Type type) {
        if (type == VECTOR_TYPE) {
            return NullBuilder.INSTANCE;
        }
        return type.newBuilder();
    }

    @Override
    public Vector.Builder newBuilderWithInitialSize(int initialSize) {
        if (initialSize == 0) {
            return NullBuilder.INSTANCE;
        }
        throw new UnsupportedOperationException("Cannot build NULL with non-zero length!");
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    @Override
    public boolean isDeferred() {
        return false;
    }

    @Override
    public Vector.Builder newBuilderWithInitialCapacity(int initialCapacity) {
        return NullBuilder.INSTANCE;
    }

    @Override
    public boolean contains(Vector vector2, int vectorIndex) {
        return false;
    }

    @Override
    public int indexOf(Vector vector2, int vectorIndex, int startIndex) {
        return -1;
    }

    @Override
    public Comparable getElementAsObject(int index) {
        throw new IllegalArgumentException(INDEX_OUT_OF_BOUNDS);
    }

    @Override
    public boolean isElementNA(int index) {
        throw new IllegalArgumentException(INDEX_OUT_OF_BOUNDS);
    }

    @Override
    public boolean isElementNaN(int index) {
        throw new IllegalArgumentException(INDEX_OUT_OF_BOUNDS);
    }

    @Override
    public boolean isElementTrue(int index) {
        throw new IllegalArgumentException(INDEX_OUT_OF_BOUNDS);
    }

    @Override
    public byte getElementAsByte(int index) {
        throw new IllegalArgumentException(INDEX_OUT_OF_BOUNDS);
    }

    @Override
    public Complex getElementAsComplex(int index) {
        throw new IllegalArgumentException(INDEX_OUT_OF_BOUNDS);
    }

    @Override
    public double getElementAsComplexIm(int index) {
        throw new IllegalArgumentException(INDEX_OUT_OF_BOUNDS);
    }

    @Override
    public Logical getElementAsLogical(int index) {
        throw new IllegalArgumentException(INDEX_OUT_OF_BOUNDS);
    }

    @Override
    public int getElementAsRawLogical(int index) {
        throw new IllegalArgumentException(INDEX_OUT_OF_BOUNDS);
    }

    @Override
    public String getElementAsString(int index) {
        throw new IllegalArgumentException(INDEX_OUT_OF_BOUNDS);
    }

    @Override
    public int getElementAsInt(int index) {
        throw new IllegalArgumentException(INDEX_OUT_OF_BOUNDS);
    }

    @Override
    public double getElementAsDouble(int index) {
        throw new IllegalArgumentException(INDEX_OUT_OF_BOUNDS);
    }

    @Override
    public boolean containsNA() {
        return false;
    }

    @Override
    public int indexOf(AtomicVector vector2, int vectorIndex, int startIndex) {
        return -1;
    }

    @Override
    public boolean contains(AtomicVector vector2, int vectorIndex) {
        return false;
    }

    @Override
    public int getComputationDepth() {
        return 0;
    }

    @Override
    public void copyTo(double[] array2, int offset, int length2) {
    }

    @Override
    public SEXP getRawTag() {
        return INSTANCE;
    }

    @Override
    public Symbol getTag() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasTag() {
        return false;
    }

    @Override
    public void setTag(SEXP tag) {
        if (tag != INSTANCE) {
            throw new IllegalArgumentException("Null object is immutable");
        }
    }

    @Override
    public int indexOfNA() {
        return -1;
    }

    @Override
    public int compare(int index1, int index2) {
        throw new IllegalArgumentException(INDEX_OUT_OF_BOUNDS);
    }

    @Override
    public Vector.Type getVectorType() {
        return VECTOR_TYPE;
    }

    @Override
    public PairList clone() {
        return this;
    }

    @Override
    public double[] toDoubleArray() {
        return new double[0];
    }

    @Override
    public int[] toIntArray() {
        return new int[0];
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }

    public int hashCode() {
        return 0;
    }

    private static class NullType
    extends Vector.Type {
        public NullType() {
            super(0);
        }

        @Override
        public Vector.Builder newBuilder() {
            return NullBuilder.INSTANCE;
        }

        @Override
        public Vector.Builder newBuilderWithInitialSize(int initialSize) {
            if (initialSize > 0) {
                throw new UnsupportedOperationException(Null.NULL_IS_IMMUTABLE);
            }
            return NullBuilder.INSTANCE;
        }

        @Override
        public Vector.Builder newBuilderWithInitialCapacity(int initialCapacity) {
            return NullBuilder.INSTANCE;
        }

        @Override
        public Vector getElementAsVector(Vector vector2, int index) {
            throw new IllegalArgumentException(Null.INDEX_OUT_OF_BOUNDS);
        }

        @Override
        public int compareElements(Vector vector1, int index1, Vector vector2, int index2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean elementsIdentical(Vector vector1, int index1, Vector vector2, int index2) {
            throw new IllegalArgumentException(Null.INDEX_OUT_OF_BOUNDS);
        }

        @Override
        public Vector to(Vector x) {
            if (x == INSTANCE) {
                return x;
            }
            throw new UnsupportedOperationException("cannot coerce vector of type " + x.getTypeName() + " to NULL");
        }
    }

    private static class NullBuilder
    implements Vector.Builder<SEXP> {
        public static final NullBuilder INSTANCE = new NullBuilder();

        private NullBuilder() {
        }

        @Override
        public Vector.Builder setNA(int index) {
            throw new UnsupportedOperationException(Null.NULL_IS_IMMUTABLE);
        }

        @Override
        public Vector.Builder setFrom(int destinationIndex, SEXP source, int sourceIndex) {
            throw new UnsupportedOperationException(Null.NULL_IS_IMMUTABLE);
        }

        @Override
        public Vector.Builder copyAttributesFrom(SEXP exp2) {
            if (exp2.hasAttributes()) {
                throw new UnsupportedOperationException(Null.NULL_IS_IMMUTABLE);
            }
            return this;
        }

        @Override
        public Vector.Builder combineAttributesFrom(SEXP vector2) {
            if (vector2.hasAttributes()) {
                throw new UnsupportedOperationException(Null.NULL_IS_IMMUTABLE);
            }
            return this;
        }

        @Override
        public Vector.Builder combineStructuralAttributesFrom(SEXP vector2) {
            if (vector2.hasAttributes()) {
                throw new UnsupportedOperationException(Null.NULL_IS_IMMUTABLE);
            }
            return this;
        }

        @Override
        public Vector.Builder addNA() {
            throw new UnsupportedOperationException(Null.NULL_IS_IMMUTABLE);
        }

        @Override
        public Vector.Builder addFrom(SEXP source, int sourceIndex) {
            throw new UnsupportedOperationException(Null.NULL_IS_IMMUTABLE);
        }

        @Override
        public Vector.Builder set(int destinationIndex, SEXP exp2) {
            throw new UnsupportedOperationException(Null.NULL_IS_IMMUTABLE);
        }

        @Override
        public Vector.Builder add(SEXP exp2) {
            throw new UnsupportedOperationException(Null.NULL_IS_IMMUTABLE);
        }

        @Override
        public Vector.Builder add(Number value) {
            throw new UnsupportedOperationException(Null.NULL_IS_IMMUTABLE);
        }

        @Override
        public Vector.Builder setAttribute(String name, SEXP value) {
            throw new UnsupportedOperationException(Null.NULL_IS_IMMUTABLE);
        }

        @Override
        public Vector.Builder setAttribute(Symbol name, SEXP value) {
            throw new UnsupportedOperationException(Null.NULL_IS_IMMUTABLE);
        }

        @Override
        public Vector.Builder removeAttribute(Symbol name) {
            return this;
        }

        @Override
        public Vector.Builder setDim(int row2, int col2) {
            throw new UnsupportedOperationException(Null.NULL_IS_IMMUTABLE);
        }

        @Override
        public SEXP getAttribute(Symbol install) {
            return INSTANCE;
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public Null build() {
            return INSTANCE;
        }
    }
}

