/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import java.util.Iterator;
import org.apache.commons.math.complex.Complex;
import org.renjin.primitives.vector.ConvertingIntVector;
import org.renjin.repackaged.guava.collect.UnmodifiableIterator;
import org.renjin.sexp.AbstractAtomicVector;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public abstract class IntVector
extends AbstractAtomicVector
implements Iterable<Integer> {
    public static final String TYPE_NAME = "integer";
    public static final int TYPE_CODE = 13;
    public static final Vector.Type VECTOR_TYPE = new IntType();
    public static final IntVector EMPTY = new IntArrayVector(new int[0]);
    public static final String IMPLICIT_CLASS = "integer";
    public static final int NA = Integer.MIN_VALUE;

    protected IntVector() {
    }

    protected IntVector(AttributeMap attributes2) {
        super(attributes2);
    }

    public static boolean isNA(int value) {
        return value == Integer.MIN_VALUE;
    }

    @Override
    public String getTypeName() {
        return "integer";
    }

    @Override
    public Vector.Type getVectorType() {
        return VECTOR_TYPE;
    }

    @Override
    public abstract int length();

    @Override
    public abstract int getElementAsInt(int var1);

    @Override
    public Logical asLogical() {
        if (this.length() == 0) {
            return Logical.NA;
        }
        return this.getElementAsLogical(0);
    }

    @Override
    public double getElementAsDouble(int index) {
        return this.isElementNA(index) ? DoubleVector.NA : (double)this.getElementAsInt(index);
    }

    @Override
    public String getElementAsString(int index) {
        int value = this.getElementAsInt(index);
        if (IntVector.isNA(value)) {
            return StringVector.NA;
        }
        return Integer.toString(value);
    }

    public SEXP getElementAsSEXP(int index) {
        return new IntArrayVector(this.getElementAsInt(index));
    }

    @Override
    public Complex getElementAsComplex(int index) {
        int intValue = this.getElementAsInt(index);
        if (IntVector.isNA(intValue)) {
            return ComplexVector.NA;
        }
        return ComplexVector.complex(intValue);
    }

    @Override
    public int getElementAsRawLogical(int index) {
        int value = this.getElementAsInt(index);
        if (value == 0 || IntVector.isNA(value)) {
            return value;
        }
        return 1;
    }

    @Override
    public Integer getElementAsObject(int index) {
        return this.getElementAsInt(index);
    }

    @Override
    public int indexOf(AtomicVector vector2, int vectorIndex, int startIndex) {
        int value = vector2.getElementAsInt(vectorIndex);
        for (int i = startIndex; i < this.length(); ++i) {
            if (value != this.getElementAsInt(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected abstract SEXP cloneWithNewAttributes(AttributeMap var1);

    @Override
    public int compare(int index1, int index2) {
        return this.getElementAsInt(index1) - this.getElementAsInt(index2);
    }

    @Override
    public IntArrayVector.Builder newBuilderWithInitialSize(int initialSize) {
        return new IntArrayVector.Builder(initialSize, initialSize);
    }

    @Override
    public IntArrayVector.Builder newBuilderWithInitialCapacity(int initialCapacity) {
        return new IntArrayVector.Builder(0, initialCapacity);
    }

    @Override
    public IntArrayVector.Builder newCopyBuilder() {
        return new IntArrayVector.Builder(this);
    }

    @Override
    public boolean isNumeric() {
        return !this.inherits("factor");
    }

    @Override
    public String getImplicitClass() {
        return "integer";
    }

    @Override
    public int[] toIntArray() {
        int[] array2 = new int[this.length()];
        for (int i = 0; i != array2.length; ++i) {
            array2[i] = this.getElementAsInt(i);
        }
        return array2;
    }

    @Override
    public void accept(SexpVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Iterator<Integer> iterator() {
        return new ValueIterator();
    }

    @Override
    public double[] toDoubleArray() {
        double[] d = new double[this.length()];
        for (int i = 0; i != d.length; ++i) {
            int x = this.getElementAsInt(i);
            d[i] = x == Integer.MIN_VALUE ? DoubleVector.NA : (double)x;
        }
        return d;
    }

    public final int hashCode() {
        int result = 1;
        for (int i = 0; i < this.length(); ++i) {
            result = 31 * result + this.getElementAsInt(i);
        }
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("c(");
        for (int i = 0; i < Math.min(5, this.length()); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (this.isElementNA(i)) {
                sb.append("NA_integer_");
                continue;
            }
            sb.append(this.getElementAsInt(i)).append("L");
        }
        if (this.length() > 5) {
            sb.append("...").append(this.length()).append(" elements total");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean isElementNA(int index) {
        return IntVector.isNA(this.getElementAsInt(index));
    }

    public static IntVector valueOf(int value) {
        return new IntArrayVector(value);
    }

    private class ValueIterator
    extends UnmodifiableIterator<Integer> {
        private int i = 0;

        private ValueIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < IntVector.this.length();
        }

        @Override
        public Integer next() {
            return IntVector.this.getElementAsInt(this.i++);
        }
    }

    private static class IntType
    extends Vector.Type {
        private IntType() {
            super(3);
        }

        @Override
        public IntArrayVector.Builder newBuilder() {
            return new IntArrayVector.Builder(0, 0);
        }

        @Override
        public IntArrayVector.Builder newBuilderWithInitialSize(int initialSize) {
            return new IntArrayVector.Builder(initialSize);
        }

        @Override
        public IntArrayVector.Builder newBuilderWithInitialCapacity(int initialCapacity) {
            return new IntArrayVector.Builder(0, initialCapacity);
        }

        @Override
        public Vector getElementAsVector(Vector vector2, int index) {
            return new IntArrayVector(vector2.getElementAsInt(index));
        }

        @Override
        public int compareElements(Vector vector1, int index1, Vector vector2, int index2) {
            assert (!vector1.isElementNA(index1) && !vector2.isElementNA(index2));
            return vector1.getElementAsInt(index1) - vector2.getElementAsInt(index2);
        }

        @Override
        public boolean elementsIdentical(Vector vector1, int index1, Vector vector2, int index2) {
            int element2;
            int element1 = vector1.getElementAsInt(index1);
            return element1 == (element2 = vector2.getElementAsInt(index2));
        }

        @Override
        public Vector to(Vector x) {
            if (x instanceof IntVector) {
                return x;
            }
            return new ConvertingIntVector(x, x.getAttributes());
        }
    }
}

