/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.s4;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.primitives.Attributes;
import org.renjin.s4.S4;
import org.renjin.s4.S4Slot;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Closure;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.S4Object;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class S4Class {
    private SEXP classRepresentation;
    private Map<String, S4Slot> slotMap = new HashMap<String, S4Slot>();
    private Map<String, String> slots = new HashMap<String, String>();

    public S4Class(SEXP classRepresentation) {
        this.classRepresentation = classRepresentation;
        ListVector slots = (ListVector)classRepresentation.getAttribute(Symbol.get("slots"));
        for (int i = 0; i < slots.length(); ++i) {
            this.slots.put(slots.getAttribute(Symbols.NAMES).getElementAsSEXP(i).asString(), slots.getElementAsString(i));
        }
    }

    public int extractDistanceFromS4Class(String otherClassName) {
        SEXP containsSexp = this.classRepresentation.getAttribute(S4.CONTAINS);
        return this.extractDistanceFromS4Class(containsSexp, otherClassName);
    }

    private int extractDistanceFromS4Class(SEXP superclassSlot, String className) {
        LogicalArrayVector condition;
        SEXP classExtension;
        Closure test;
        ListVector containsList;
        int index;
        if (superclassSlot instanceof ListVector && (index = (containsList = (ListVector)superclassSlot).getIndexByName(className)) != -1 && (test = (Closure)(classExtension = containsList.getElementAsSEXP(index)).getAttribute(S4.TEST)).getBody() instanceof LogicalArrayVector && (condition = (LogicalArrayVector)test.getBody()).isElementTrue(0)) {
            SEXP distanceAttribute = classExtension.getAttribute(S4.DISTANCE);
            return distanceAttribute.asInt();
        }
        return -1;
    }

    public int getDistanceToUnionClass(String className) {
        if (this.isUnionClass()) {
            SEXP subclasses = this.classRepresentation.getAttribute(S4.SUBCLASSES);
            return this.extractDistanceFromS4Class(subclasses, className);
        }
        return -1;
    }

    public boolean isUnionClass() {
        String objClass = this.classRepresentation.getAttribute(Symbols.CLASS).asString();
        return "ClassUnionRepresentation".equals(objClass);
    }

    public boolean isSimpleCoercion(String targetClass) {
        ListVector contains = (ListVector)this.classRepresentation.getAttribute(S4.CONTAINS);
        int index = contains.getIndexByName(targetClass);
        if (index != -1) {
            SEXP classExtension = contains.getElementAsSEXP(index);
            SEXP simple = classExtension.getAttribute(S4.SIMPLE);
            return ((LogicalArrayVector)simple).isElementTrue(0);
        }
        return true;
    }

    public SEXP coerceTo(Context context, SEXP value, String to) {
        ListVector contains = (ListVector)this.classRepresentation.getAttribute(S4.CONTAINS);
        int toIndex = contains.getIndexByName(to);
        if (toIndex != -1) {
            S4Object fromClass = (S4Object)contains.getElementAsSEXP(toIndex);
            Closure coerce = (Closure)fromClass.getAttribute(S4.COERCE);
            FunctionCall call2 = new FunctionCall(coerce, new PairList.Node(value, Null.INSTANCE));
            SEXP res = context.evaluate(call2);
            if (fromClass.getAttribute(S4.BY).length() == 0) {
                return res;
            }
            String by = fromClass.getAttribute(S4.BY).asString();
            int byIndex = contains.getIndexByName(by);
            if (byIndex != -1) {
                S4Object byClass = (S4Object)contains.getElementAsSEXP(byIndex);
                Closure byCoerce = (Closure)byClass.getAttribute(S4.COERCE);
                FunctionCall byCall = new FunctionCall(byCoerce, new PairList.Node(value, Null.INSTANCE));
                return context.evaluate(byCall);
            }
            FunctionCall byCall = new FunctionCall(Symbol.get(by), new PairList.Node(call2, Null.INSTANCE));
            return context.evaluate(byCall);
        }
        return value;
    }

    public SEXP getDefinition() {
        return this.classRepresentation;
    }

    public S4Slot getSlot(Context context, String name) {
        S4Slot slot = this.slotMap.get(name);
        if (slot == null) {
            slot = this.findSlotFromClassRepresentation(context, name);
            this.slotMap.put(name, slot);
        }
        return slot;
    }

    private S4Slot findSlotFromClassRepresentation(Context context, String name) {
        if (this.slots.containsKey(name)) {
            ArrayList<String> classNames = new ArrayList<String>();
            String slotClassName = this.slots.get(name);
            AtomicVector validClasses = S4.computeDataClassesS4(context, slotClassName);
            classNames.add(slotClassName);
            return new S4Slot(name, classNames);
        }
        throw new EvalException(name + " is not a slot in class " + Attributes.getClass(this.classRepresentation).getElementAsString(0), new Object[0]);
    }
}

