/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.s4;

import java.util.Arrays;
import org.renjin.eval.Context;
import org.renjin.s4.DistanceCalculator;
import org.renjin.s4.Method;
import org.renjin.s4.Signature;
import org.renjin.sexp.Closure;

public class RankedMethod {
    private final Method method;
    private boolean has0;
    private boolean candidate = true;
    private boolean exact = true;
    private int[] distances;

    public RankedMethod(Context context, Method method, Signature callingSignature, DistanceCalculator distanceCalculator, boolean[] useInheritance) {
        this.method = method;
        this.distances = new int[this.getMethodSignatureLength()];
        for (int i = 0; i < this.getMethodSignatureLength(); ++i) {
            String targetClass;
            String definedClass = method.getSignature().getClass(i);
            if (definedClass.equals(targetClass = callingSignature.getClass(i))) {
                this.distances[i] = 0;
                this.has0 = true;
                continue;
            }
            if (useInheritance[i]) {
                this.exact = false;
                int distance = distanceCalculator.distance(context, targetClass, definedClass);
                if (distance == -1) {
                    this.candidate = false;
                    break;
                }
                this.distances[i] = distance;
                continue;
            }
            this.candidate = false;
            break;
        }
    }

    public boolean isCandidate() {
        return this.candidate;
    }

    public boolean isExact() {
        return this.exact;
    }

    public boolean isBetterThan(RankedMethod other) {
        if (this.has0 && !other.has0) {
            return true;
        }
        if (!this.has0 && other.has0) {
            return false;
        }
        for (int i = 0; i < this.distances.length && i < other.distances.length; ++i) {
            if (this.distances[i] < other.distances[i]) {
                return true;
            }
            if (this.distances[i] <= other.distances[i]) continue;
            return false;
        }
        return this.method.getSpecificity() < other.method.getSpecificity();
    }

    public Method getMethod() {
        return this.method;
    }

    public Closure getMethodDefinition() {
        return this.method.getDefinition();
    }

    public String toString() {
        return "RankedMethod{method=" + this.method + ", has0=" + this.has0 + ", candidate=" + this.candidate + ", exact=" + this.exact + ", distances=" + Arrays.toString(this.distances) + '}';
    }

    public String getArgumentClass(int index) {
        return this.method.getSignature().getClass(index);
    }

    public int getMethodSignatureLength() {
        return this.method.getSignature().getLength();
    }
}

