/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.s4;

import org.renjin.s4.Generic;
import org.renjin.s4.Signature;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Closure;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;

public class Method {
    public static final int SPECIFICITY_GENERIC = 0;
    public static final int SPECIFICITY_SUB_GROUP = 1;
    public static final int SPECIFICITY_GROUP = 2;
    private Generic generic;
    private int specificity;
    private Signature signature;
    private Closure definition;

    public Method(Generic generic, int specificity, String signature, SEXP definition) {
        this.generic = generic;
        this.specificity = specificity;
        this.signature = new Signature(signature);
        this.definition = (Closure)definition;
    }

    public int getSignatureLength() {
        return this.signature.getLength();
    }

    public Closure getDefinition() {
        return this.definition;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public boolean isGroupGeneric() {
        return this.specificity != 0;
    }

    public int getSpecificity() {
        return this.specificity;
    }

    public PairList getFormals() {
        return this.definition.getFormals();
    }

    public AtomicVector getFormalNames() {
        return this.getFormals().getNames();
    }

    public String toString() {
        switch (this.specificity) {
            case 1: {
                return this.generic.getSubGroup() + "(" + this.signature + ")";
            }
            case 2: {
                return this.generic.getGroup() + "(" + this.signature + ")";
            }
        }
        return this.generic.getName() + "(" + this.signature + ")";
    }

    public Generic getGeneric() {
        return this.generic;
    }
}

