/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.s4;

import java.util.Iterator;
import java.util.Set;
import org.renjin.eval.ArgumentMatcher;
import org.renjin.eval.Calls;
import org.renjin.eval.Context;
import org.renjin.eval.MatchedArguments;
import org.renjin.s4.Signature;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Promise;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class CallingArguments {
    private static final String MISSING = "missing";
    private final Context context;
    private final PairList promisedArgs;

    private CallingArguments(Context context, PairList promisedArgs) {
        this.context = context;
        this.promisedArgs = promisedArgs;
    }

    public static CallingArguments primitiveArguments(Context context, Environment rho, ArgumentMatcher matcher, SEXP object2, PairList args2) {
        PairList promisedArgs;
        PairList expandedArgs = Calls.promiseArgs(args2, context, rho);
        if (matcher.getNamedFormalCount() == expandedArgs.length()) {
            promisedArgs = expandedArgs;
        } else {
            MatchedArguments matchedArguments = matcher.match(expandedArgs);
            promisedArgs = CallingArguments.matchByName(rho, object2, matchedArguments);
        }
        return new CallingArguments(context, promisedArgs);
    }

    public static CallingArguments standardGenericArguments(Context context, ArgumentMatcher argumentMatcher) {
        Environment environment2 = context.getEnvironment();
        PairList.Builder promisedArgs = new PairList.Builder();
        for (int i = 0; i < argumentMatcher.getFormalNames().size(); ++i) {
            String formalName = argumentMatcher.getFormalNames().get(i);
            SEXP promisedArg = environment2.getVariableUnsafe(formalName);
            boolean missing2 = environment2.isMissingArgument(Symbol.get(formalName));
            if (formalName.equals("...")) {
                promisedArgs.addAll((PairList)promisedArg);
                continue;
            }
            if (!missing2) {
                promisedArgs.add(formalName, promisedArg);
                continue;
            }
            promisedArgs.add(formalName, (SEXP)Symbol.MISSING_ARG);
        }
        return new CallingArguments(context, promisedArgs.build());
    }

    private static PairList matchByName(Environment rho, SEXP object2, MatchedArguments matchedArguments) {
        PairList.Builder promisedArgs = new PairList.Builder();
        for (int formalIndex = 0; formalIndex < matchedArguments.getFormalCount(); ++formalIndex) {
            Symbol formalName = matchedArguments.getFormalName(formalIndex);
            int actualIndex = matchedArguments.getActualIndex(formalIndex);
            if (actualIndex == -1) {
                if (formalName == Symbols.ELLIPSES) continue;
                promisedArgs.add(formalName, (SEXP)Symbol.MISSING_ARG);
                continue;
            }
            SEXP uneval = matchedArguments.getActualValue(actualIndex);
            if (actualIndex == 0) {
                promisedArgs.add(formalName, (SEXP)new Promise(uneval, object2));
                continue;
            }
            promisedArgs.add(formalName, (SEXP)Promise.repromise(rho, uneval));
        }
        return promisedArgs.build();
    }

    public PairList getPromisedArgs() {
        return this.promisedArgs;
    }

    public Signature getSignature(int length2) {
        String[] classes = new String[length2];
        Iterator<PairList.Node> argumentIt = this.promisedArgs.nodes().iterator();
        for (int index = 0; index < length2; ++index) {
            classes[index] = argumentIt.hasNext() ? this.getArgumentClass(index) : MISSING;
        }
        return new Signature(classes);
    }

    public Signature getSignature(int length2, Set<String> args2) {
        String[] classes = new String[length2];
        Iterator<PairList.Node> argumentIt = this.promisedArgs.nodes().iterator();
        int step = 0;
        int index = 0;
        while (step < length2) {
            if (argumentIt.hasNext()) {
                String nodeTag = argumentIt.next().getName();
                if (args2.isEmpty() || args2.contains(nodeTag)) {
                    classes[step] = this.getArgumentClass(index);
                    ++step;
                }
            } else {
                classes[step] = MISSING;
                ++step;
            }
            ++index;
        }
        return new Signature(classes);
    }

    public StringBuilder getFullSignatureString(int length2) {
        StringBuilder sb = new StringBuilder();
        Iterator<PairList.Node> argumentIt = this.promisedArgs.nodes().iterator();
        for (int i = 0; i < length2; ++i) {
            if (!argumentIt.hasNext()) continue;
            sb.append(" '");
            sb.append(this.getArgumentClass(i));
            if (i == length2 - 1) {
                sb.append("'");
                continue;
            }
            sb.append("', ");
        }
        return sb;
    }

    public String getArgumentClass(int index) {
        if (index >= this.promisedArgs.length()) {
            return MISSING;
        }
        Object actual = this.promisedArgs.getElementAsSEXP(index);
        SEXP evaluated = actual.force(this.context);
        if (evaluated == Symbol.MISSING_ARG) {
            return MISSING;
        }
        return this.computeDateClass(evaluated);
    }

    private String computeDateClass(SEXP evaluated) {
        AtomicVector classAttribute = evaluated.getAttributes().getClassVector();
        if (classAttribute.length() > 0) {
            return classAttribute.getElementAsString(0);
        }
        Vector dim2 = evaluated.getAttributes().getDim();
        if (dim2.length() == 2) {
            return "matrix";
        }
        if (dim2.length() > 0) {
            return "array";
        }
        if (evaluated instanceof IntVector) {
            return "integer";
        }
        if (evaluated instanceof DoubleVector) {
            return "numeric";
        }
        return evaluated.getImplicitClass();
    }
}

