/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.repackaged.guava.collect;

import java.lang.reflect.Array;
import java.util.Collection;
import javax.annotation.Nullable;
import org.renjin.repackaged.guava.annotations.GwtCompatible;
import org.renjin.repackaged.guava.annotations.GwtIncompatible;
import org.renjin.repackaged.guava.base.Preconditions;
import org.renjin.repackaged.guava.collect.Platform;

@GwtCompatible(emulated=true)
public final class ObjectArrays {
    static final Object[] EMPTY_ARRAY = new Object[0];

    private ObjectArrays() {
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    public static <T> T[] newArray(Class<T> type, int length2) {
        return (Object[])Array.newInstance(type, length2);
    }

    public static <T> T[] newArray(T[] reference, int length2) {
        return Platform.newArray(reference, length2);
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    public static <T> T[] concat(T[] first, T[] second, Class<T> type) {
        T[] result = ObjectArrays.newArray(type, first.length + second.length);
        System.arraycopy(first, 0, result, 0, first.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static <T> T[] concat(@Nullable T element, T[] array2) {
        T[] result = ObjectArrays.newArray(array2, array2.length + 1);
        result[0] = element;
        System.arraycopy(array2, 0, result, 1, array2.length);
        return result;
    }

    public static <T> T[] concat(T[] array2, @Nullable T element) {
        T[] result = ObjectArrays.arraysCopyOf(array2, array2.length + 1);
        result[array2.length] = element;
        return result;
    }

    static <T> T[] arraysCopyOf(T[] original, int newLength) {
        T[] copy2 = ObjectArrays.newArray(original, newLength);
        System.arraycopy(original, 0, copy2, 0, Math.min(original.length, newLength));
        return copy2;
    }

    static <T> T[] toArrayImpl(Collection<?> c2, T[] array2) {
        int size = c2.size();
        if (array2.length < size) {
            array2 = ObjectArrays.newArray(array2, size);
        }
        ObjectArrays.fillArray(c2, array2);
        if (array2.length > size) {
            array2[size] = null;
        }
        return array2;
    }

    static <T> T[] toArrayImpl(Object[] src, int offset, int len, T[] dst) {
        Preconditions.checkPositionIndexes(offset, offset + len, src.length);
        if (dst.length < len) {
            dst = ObjectArrays.newArray(dst, len);
        } else if (dst.length > len) {
            dst[len] = null;
        }
        System.arraycopy(src, offset, dst, 0, len);
        return dst;
    }

    static Object[] toArrayImpl(Collection<?> c2) {
        return ObjectArrays.fillArray(c2, new Object[c2.size()]);
    }

    static Object[] copyAsObjectArray(Object[] elements, int offset, int length2) {
        Preconditions.checkPositionIndexes(offset, offset + length2, elements.length);
        if (length2 == 0) {
            return EMPTY_ARRAY;
        }
        Object[] result = new Object[length2];
        System.arraycopy(elements, offset, result, 0, length2);
        return result;
    }

    private static Object[] fillArray(Iterable<?> elements, Object[] array2) {
        int i = 0;
        for (Object element : elements) {
            array2[i++] = element;
        }
        return array2;
    }

    static void swap(Object[] array2, int i, int j) {
        Object temp = array2[i];
        array2[i] = array2[j];
        array2[j] = temp;
    }

    static Object[] checkElementsNotNull(Object ... array2) {
        return ObjectArrays.checkElementsNotNull(array2, array2.length);
    }

    static Object[] checkElementsNotNull(Object[] array2, int length2) {
        for (int i = 0; i < length2; ++i) {
            ObjectArrays.checkElementNotNull(array2[i], i);
        }
        return array2;
    }

    static Object checkElementNotNull(Object element, int index) {
        if (element == null) {
            throw new NullPointerException("at index " + index);
        }
        return element;
    }
}

