/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.repackaged.guava.base;

import javax.annotation.Nullable;
import org.renjin.repackaged.guava.annotations.Beta;
import org.renjin.repackaged.guava.annotations.GwtCompatible;
import org.renjin.repackaged.guava.base.Preconditions;
import org.renjin.repackaged.guava.base.VerifyException;

@Beta
@GwtCompatible
public final class Verify {
    public static void verify(boolean expression2) {
        if (!expression2) {
            throw new VerifyException();
        }
    }

    public static void verify(boolean expression2, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression2) {
            throw new VerifyException(Preconditions.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static <T> T verifyNotNull(@Nullable T reference) {
        return Verify.verifyNotNull(reference, "expected a non-null reference", new Object[0]);
    }

    public static <T> T verifyNotNull(@Nullable T reference, @Nullable String errorMessageTemplate, Object ... errorMessageArgs) {
        Verify.verify(reference != null, errorMessageTemplate, errorMessageArgs);
        return reference;
    }

    private Verify() {
    }
}

