/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.text;

import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.gcc.format.Formatter;
import org.renjin.invoke.annotations.ArgumentList;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.DataParallel;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.InvokeAsCharacter;
import org.renjin.invoke.annotations.Materialize;
import org.renjin.invoke.annotations.PreserveAttributeStyle;
import org.renjin.invoke.annotations.Recycle;
import org.renjin.primitives.Deparse;
import org.renjin.primitives.matrix.IntMatrixBuilder;
import org.renjin.primitives.print.StringPrinter;
import org.renjin.primitives.sequence.RepStringVector;
import org.renjin.primitives.text.RCharsets;
import org.renjin.primitives.text.ReservedWords;
import org.renjin.primitives.text.VectorFormatInput;
import org.renjin.primitives.text.regex.FuzzyMatcher;
import org.renjin.primitives.text.regex.RE;
import org.renjin.primitives.text.regex.REFactory;
import org.renjin.repackaged.guava.base.Function;
import org.renjin.repackaged.guava.base.Joiner;
import org.renjin.repackaged.guava.collect.Iterables;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.Promise;
import org.renjin.sexp.RawVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Text {
    public static final IntVector NO_MATCH = new IntArrayVector(new int[]{-1}, AttributeMap.newBuilder().set("match.length", (SEXP)new IntArrayVector(-1)).build());

    private Text() {
    }

    @Internal
    public static StringVector paste(@Current Context context, ListVector arguments, String separator, String collapse) {
        int resultLength = arguments.maxElementLength();
        ArrayList<StringVector> argumentVectors = new ArrayList<StringVector>();
        for (SEXP argument : arguments) {
            if (argument instanceof StringVector) {
                argumentVectors.add((StringVector)argument);
                continue;
            }
            SEXP result = context.evaluate(FunctionCall.newCall(Symbol.get("as.character"), Promise.repromise(argument)));
            if (!(result instanceof StringVector)) {
                throw new EvalException("as.character() returned non-character", new Object[0]);
            }
            argumentVectors.add((StringVector)result);
        }
        if (collapse == null) {
            String[] results = new String[resultLength];
            for (int index = 0; index != resultLength; ++index) {
                results[index] = Joiner.on(separator).join(Iterables.transform(argumentVectors, new StringElementAt(index)));
            }
            return new StringArrayVector(results);
        }
        StringBuilder result = new StringBuilder();
        for (int index = 0; index != resultLength; ++index) {
            if (index != 0) {
                result.append(collapse);
            }
            Joiner.on(separator).appendTo(result, Iterables.transform(argumentVectors, new StringElementAt(index)));
        }
        return StringVector.valueOf(result.toString());
    }

    @Internal(value="encodeString")
    public static StringVector encodeString(StringVector x, int width, String quote, int justify, boolean naEncode) {
        StringPrinter printer = new StringPrinter();
        StringVector.Builder result = new StringVector.Builder(0, x.length());
        if (!StringVector.isNA(quote) && !quote.isEmpty()) {
            printer.setQuote(quote.charAt(0));
        }
        for (int i = 0; i < x.length(); ++i) {
            String element = x.getElementAsString(i);
            if (!naEncode && StringVector.isNA(element)) {
                result.addNA();
                continue;
            }
            result.add(printer.apply(element));
        }
        for (Symbol attribute : x.getAttributes().names()) {
            if (attribute == Symbols.CLASS) continue;
            result.setAttribute(attribute, x.getAttribute(attribute));
        }
        return result.build();
    }

    /*
     * WARNING - void declaration
     */
    @Internal
    @Materialize
    public static StringVector sprintf(@Current Context context, @Current Environment rho, StringVector format2, @ArgumentList ListVector arguments) {
        int n;
        if (format2.length() == 0) {
            return StringVector.EMPTY;
        }
        StringVector.Builder result = StringVector.newBuilder();
        Formatter[] formatters = new Formatter[format2.length()];
        for (int i = 0; i != format2.length(); ++i) {
            formatters[i] = new Formatter(format2.getElementAsString(i));
        }
        AtomicVector[] formatArgs = new AtomicVector[arguments.length()];
        for (int i = 0; i != formatArgs.length; ++i) {
            void var8_9;
            SEXP sEXP = arguments.getElementAsSEXP(i);
            if (formatters[0].getArgumentType(i) == Formatter.ArgumentType.STRING && !(sEXP instanceof StringVector)) {
                SEXP sEXP2 = context.evaluate(FunctionCall.newCall(Symbol.get("as.character"), sEXP), rho);
            }
            if (!(var8_9 instanceof AtomicVector)) {
                throw new EvalException("Format argument %d is not an atomic vector", i);
            }
            formatArgs[i] = (AtomicVector)var8_9;
        }
        int argumentCount = 0;
        for (Formatter formatter : formatters) {
            if (formatter.getArgumentTypes().size() <= argumentCount) continue;
            argumentCount = formatter.getArgumentTypes().size();
        }
        if (argumentCount > arguments.length()) {
            throw new EvalException("Too few arguments provided for format string", new Object[0]);
        }
        int n2 = formatters.length;
        for (AtomicVector formatArg : formatArgs) {
            if (formatArg.length() == 0) {
                return StringVector.EMPTY;
            }
            if (formatArg.length() <= n) continue;
            n = formatArg.length();
        }
        VectorFormatInput input = new VectorFormatInput(formatArgs);
        for (int resultIndex = 0; resultIndex != n; ++resultIndex) {
            Formatter formatter = formatters[resultIndex % formatters.length];
            result.add(formatter.format(input));
            input.next();
        }
        return result.build();
    }

    @Internal
    public static StringVector gettext(String domain, StringVector messages) {
        return messages;
    }

    @Internal
    public static String ngettext(double n, String singularMessage, String pluralMessage, String domain) {
        return n == 1.0 ? singularMessage : pluralMessage;
    }

    @Internal
    public static void bindtextdomain(String domain, String dirname2) {
    }

    @Internal
    public static StringVector enc2utf8(StringVector inputVector) {
        return inputVector;
    }

    @Internal(value="chartr")
    @DataParallel
    public static String chartr(String oldChars, String newChars, @Recycle String x) {
        StringBuilder translation = new StringBuilder(x.length());
        for (int i = 0; i != x.length(); ++i) {
            int codePoint = x.codePointAt(i);
            int charIndex = oldChars.indexOf(codePoint);
            if (charIndex == -1) {
                translation.appendCodePoint(codePoint);
                continue;
            }
            translation.appendCodePoint(newChars.codePointAt(charIndex));
        }
        return translation.toString();
    }

    @Internal
    @DataParallel
    public static String tolower(String x) {
        return x.toLowerCase();
    }

    @Internal
    @DataParallel
    public static String toupper(String x) {
        return x.toUpperCase();
    }

    @Internal
    @DataParallel(passNA=true)
    public static int nchar(@Recycle String x, String type, boolean allowNA) {
        if (StringVector.isNA(x)) {
            return 2;
        }
        return x.length();
    }

    @Internal
    @DataParallel
    public static String sub(String pattern, String replacement, @Recycle String x, boolean ignoreCase, boolean perl, boolean fixed, boolean useBytes) {
        RE re = REFactory.compile(pattern, ignoreCase, perl, fixed, useBytes);
        return re.subst(x, replacement, 3);
    }

    @Internal
    @DataParallel
    public static String gsub(String pattern, String replacement, @Recycle String x, boolean ignoreCase, boolean perl, boolean fixed, boolean useBytes) {
        RE re = REFactory.compile(pattern, ignoreCase, perl, fixed, useBytes);
        return re.subst(x, replacement, 2);
    }

    @Internal
    @DataParallel
    public static StringVector strsplit(@Recycle String x, @Recycle String split2, boolean fixed, boolean perl, boolean useBytes) {
        RE re = REFactory.compile(split2, false, perl, fixed, useBytes);
        return new StringArrayVector(re.split(x));
    }

    @Internal
    public static Vector grep(String pattern, StringVector x, boolean ignoreCase, boolean value, boolean perl, boolean fixed, boolean useBytes, boolean invert) {
        if (StringVector.isNA(pattern)) {
            return new StringArrayVector(new String[x.length()]);
        }
        RE re = REFactory.compile(pattern, ignoreCase, perl, fixed, useBytes);
        if (value) {
            StringVector.Builder result = new StringVector.Builder();
            for (String string : x) {
                if (!re.match(string)) continue;
                result.add(string);
            }
            return result.build();
        }
        IntArrayVector.Builder result = new IntArrayVector.Builder(0);
        for (int i = 0; i != x.length(); ++i) {
            if (x.isElementNA(i) || !re.match(x.getElementAsString(i))) continue;
            result.add(i + 1);
        }
        return result.build();
    }

    @Internal
    public static Vector grepl(String pattern, StringVector x, boolean ignoreCase, boolean value, boolean perl, boolean fixed, boolean useBytes, boolean invert) {
        if (StringVector.isNA(pattern)) {
            return new StringArrayVector(new String[x.length()]);
        }
        RE re = REFactory.compile(pattern, ignoreCase, perl, fixed, useBytes);
        LogicalArrayVector.Builder result = new LogicalArrayVector.Builder();
        for (String string : x) {
            result.add(!StringVector.isNA(string) && re.match(string));
        }
        return result.build();
    }

    @Internal
    public static Vector agrep(String pattern, StringVector x, boolean ignoreCase, boolean value, Vector costs, Vector bounds, boolean useBytes, boolean fixed) {
        if (!fixed) {
            throw new EvalException("fixed = FALSE not impelmented for agrep.", new Object[0]);
        }
        if (StringVector.isNA(pattern)) {
            return new StringArrayVector(new String[x.length()]);
        }
        int maxDistance = Text.maxDistance(bounds, pattern);
        FuzzyMatcher matcher = new FuzzyMatcher(pattern, ignoreCase);
        if (value) {
            StringVector.Builder result = new StringVector.Builder();
            for (int i = 0; i != x.length(); ++i) {
                if (matcher.contains(x.getElementAsString(i)) > maxDistance) continue;
                result.add(x.getElementAsString(i));
            }
            return result.build();
        }
        IntArrayVector.Builder result = new IntArrayVector.Builder();
        for (int i = 0; i != x.length(); ++i) {
            if (matcher.contains(x.getElementAsString(i)) > maxDistance) continue;
            result.add(i + 1);
        }
        return result.build();
    }

    private static int maxDistance(Vector bounds, String pattern) {
        if (bounds.length() != 5) {
            throw new EvalException("Expected bounds argument of length 5", new Object[0]);
        }
        if (!(bounds.isElementNA(1) && bounds.isElementNA(2) && bounds.isElementNA(3) && bounds.isElementNA(4))) {
            throw new EvalException("max distance with specific components (all, insertions, deletions, substitutions not implemented", new Object[0]);
        }
        double maxDistance = bounds.getElementAsDouble(0);
        if (maxDistance < 1.0) {
            maxDistance *= (double)pattern.length();
        }
        return (int)Math.ceil(maxDistance);
    }

    @Internal
    public static IntVector regexpr(String pattern, StringVector vector2, boolean ignoreCase, boolean perl, boolean fixed, boolean useBytes) {
        RE re = REFactory.compile(pattern, ignoreCase, perl, fixed, useBytes);
        IntArrayVector.Builder position = IntArrayVector.Builder.withInitialCapacity(vector2.length());
        IntArrayVector.Builder matchLength = IntArrayVector.Builder.withInitialCapacity(vector2.length());
        int groups = re.getGroupCount();
        IntMatrixBuilder captureStart = null;
        IntMatrixBuilder captureLength = null;
        StringVector captureNames = null;
        if (groups > 0) {
            captureNames = RepStringVector.createConstantVector("", groups);
            captureStart = new IntMatrixBuilder(vector2.length(), groups);
            captureLength = new IntMatrixBuilder(vector2.length(), groups);
            captureStart.fill(-1);
            captureLength.fill(-1);
            captureStart.setColNames(captureNames);
            captureLength.setColNames(captureNames);
        }
        for (int i = 0; i < vector2.length(); ++i) {
            if (re.match(vector2.getElementAsString(i))) {
                int start = re.getGroupStart(0);
                int end = re.getGroupEnd(0);
                position.add(start + 1);
                matchLength.add(end - start);
                for (int group = 1; group <= re.getGroupCount(); ++group) {
                    int groupStart = re.getGroupStart(group);
                    if (groupStart == -1) {
                        captureStart.set(i, group - 1, 0);
                        captureLength.set(i, group - 1, 0);
                        continue;
                    }
                    captureStart.set(i, group - 1, groupStart + 1);
                    captureLength.set(i, group - 1, re.getGroupEnd(group) - groupStart);
                }
                continue;
            }
            position.add(-1);
            matchLength.add(-1);
        }
        position.setAttribute("match.length", (SEXP)matchLength.build());
        position.setAttribute("useBytes", (SEXP)new LogicalArrayVector(useBytes));
        if (groups > 0) {
            position.setAttribute("capture.start", (SEXP)captureStart.build());
            position.setAttribute("capture.length", (SEXP)captureLength.build());
            position.setAttribute("capture.names", (SEXP)captureNames);
        }
        return position.build();
    }

    @Internal
    public static ListVector regexec(String pattern, StringVector vector2, boolean ignoreCase, boolean fixed, boolean useBytes) {
        RE re = REFactory.compile(pattern, ignoreCase, false, fixed, useBytes);
        int groupCount = re.getGroupCount();
        ListVector.Builder results = new ListVector.Builder(0, vector2.length());
        int[] starts = new int[groupCount + 1];
        int[] lengths = new int[groupCount + 1];
        for (String text : vector2) {
            if (re.match(text)) {
                for (int i = 0; i <= groupCount; ++i) {
                    int start = re.getGroupStart(i);
                    starts[i] = start + 1;
                    lengths[i] = re.getGroupEnd(i) - start;
                }
                IntArrayVector lengthVector = new IntArrayVector(lengths);
                AttributeMap matchAttributes = AttributeMap.builder().set("match.length", (SEXP)lengthVector).build();
                IntArrayVector match2 = new IntArrayVector(starts, matchAttributes);
                results.add(match2);
                continue;
            }
            results.add(NO_MATCH);
        }
        return results.build();
    }

    @Internal
    public static ListVector gregexpr(String pattern, StringVector vector2, boolean ignoreCase, boolean perl, boolean fixed, boolean useBytes) {
        ListVector.Builder regexpResults = new ListVector.Builder(0, vector2.length());
        RE re = REFactory.compile(pattern, ignoreCase, perl, fixed, useBytes);
        for (String text : vector2) {
            IntArrayVector.Builder position = IntArrayVector.Builder.withInitialCapacity(vector2.length());
            IntArrayVector.Builder matchLength = IntArrayVector.Builder.withInitialCapacity(vector2.length());
            int offsetSearch = 0;
            while (re.match(text.substring(offsetSearch))) {
                int increment;
                int start = re.getGroupStart(0);
                int end = re.getGroupEnd(0);
                int n = increment = end == 0 ? 1 : end;
                if (offsetSearch >= text.length()) break;
                position.add(start + 1 + offsetSearch);
                matchLength.add(end - start);
                offsetSearch += increment;
            }
            if (position.length() == 0) {
                position.add(-1);
                matchLength.add(-1);
            }
            position.setAttribute("match.length", (SEXP)matchLength.build());
            position.setAttribute("useBytes", (SEXP)new LogicalArrayVector(useBytes));
            regexpResults.add(position.build());
        }
        return regexpResults.build();
    }

    @Internal
    public static StringVector substr(StringVector x, Vector start, Vector stop2) {
        int len = x.length();
        if (len == 0) {
            return StringVector.EMPTY;
        }
        StringVector.Builder result = new StringVector.Builder();
        int k = start.length();
        int l = stop2.length();
        if (k == 0 || l == 0) {
            throw new EvalException("invalid substring arguments", new Object[0]);
        }
        for (int i = 0; i < len; ++i) {
            int startIndex = start.getElementAsInt(i % k);
            int stopIndex = stop2.getElementAsInt(i % l);
            String element = x.getElementAsString(i);
            if (IntVector.isNA(startIndex) || IntVector.isNA(stopIndex) || StringVector.isNA(element)) {
                result.add(StringVector.NA);
                continue;
            }
            int slen = element.length();
            if (startIndex < 1) {
                startIndex = 1;
            }
            if (startIndex > stopIndex || startIndex > slen) {
                result.add("");
                continue;
            }
            if (stopIndex >= slen) {
                result.add(element.substring(startIndex - 1));
                continue;
            }
            result.add(element.substring(startIndex - 1, stopIndex));
        }
        return result.build();
    }

    @Internal(value="make.names")
    @DataParallel(passNA=true)
    public static String makeNames(@Recycle String name, @Recycle(value=false) boolean allow) {
        if (StringVector.isNA(name)) {
            return "NA.";
        }
        if (name.isEmpty() || !Symbols.legalFirstCharacter(name)) {
            return "X" + Text.replaceIllegalCharacters(name);
        }
        if (ReservedWords.isReserved(name)) {
            return name + ".";
        }
        return Text.replaceIllegalCharacters(name);
    }

    private static String replaceIllegalCharacters(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        for (int i = 0; i != name.length(); ++i) {
            int cp = name.codePointAt(i);
            if (cp == 95 || Character.isDigit(cp) || Character.isLetter(cp)) {
                sb.appendCodePoint(cp);
                continue;
            }
            sb.append('.');
        }
        return sb.toString();
    }

    @Internal(value="make.unique")
    public static StringVector makeUnique(StringVector names2, String sep) {
        HashSet<String> set2 = new HashSet<String>();
        StringVector.Builder result = new StringVector.Builder();
        for (String name : names2) {
            String uniqueName = Text.makeUnique(sep, set2, name);
            result.add(uniqueName);
            set2.add(uniqueName);
        }
        return result.build();
    }

    private static String makeUnique(String sep, Set<String> set2, String name) {
        if (set2.contains(name)) {
            String newName;
            int i = 1;
            while (set2.contains(newName = name + sep + i)) {
                ++i;
            }
            return newName;
        }
        return name;
    }

    @Internal
    @DataParallel
    public static String strtrim(String source, int n) {
        int index = n > source.length() ? source.length() : n;
        return source.substring(0, index);
    }

    @Internal
    public static StringVector format(StringVector x, boolean trim, SEXP digits, SEXP nsmall, SEXP minWidth, int zz, boolean naEncode, SEXP scientific) {
        List<String> elements = Text.formatCharacterElements(x, naEncode);
        int width = Text.calculateWidth(elements, minWidth);
        elements = Text.justify(elements, width, Justification.LEFT, naEncode);
        return Text.buildFormatResult(x, elements);
    }

    @Internal
    public static StringVector format(LogicalVector x, boolean trim, SEXP digits, SEXP nsmall, SEXP minWidth, int zz, boolean naEncode, SEXP scientific) {
        List<String> elements = Text.formatLogicalElements(x);
        int width = Text.calculateWidth(elements, minWidth);
        elements = Text.justify(elements, width, Justification.RIGHT, naEncode);
        return Text.buildFormatResult(x, elements);
    }

    @Internal
    @Materialize
    public static StringVector format(DoubleVector x, boolean trim, SEXP digits, int nsmall, SEXP minWidth, int zz, boolean naEncode, SEXP scientific) {
        List<String> elements = Text.formatNumericalElements(x);
        int width = Text.calculateWidth(elements, minWidth);
        if (!trim) {
            elements = Text.justify(elements, width, Justification.RIGHT, naEncode);
        }
        return Text.buildFormatResult(x, elements);
    }

    @Internal
    @Materialize
    public static StringVector format(IntVector x, boolean trim, SEXP digits, int nsmall, SEXP minWidth, int zz, boolean naEncode, SEXP scientific) {
        List<String> elements = Text.formatNumericalElements(x);
        int width = Text.calculateWidth(elements, minWidth);
        if (!trim) {
            elements = Text.justify(elements, width, Justification.RIGHT, naEncode);
        }
        return Text.buildFormatResult(x, elements);
    }

    private static StringVector buildFormatResult(Vector x, List<String> elements) {
        StringVector.Builder result = new StringVector.Builder();
        result.addAll(elements);
        result.combineStructuralAttributesFrom(x);
        return result.build();
    }

    private static int calculateWidth(Iterable<String> elements, SEXP minWidth) {
        int width = 0;
        if (minWidth != Null.INSTANCE) {
            width = ((AtomicVector)minWidth).getElementAsInt(0);
        }
        for (String element : elements) {
            width = Math.max(width, Text.stringWidth(element));
        }
        return width;
    }

    private static int stringWidth(String element) {
        if (StringVector.isNA(element)) {
            return "NA".length();
        }
        return element.length();
    }

    private static List<String> justify(Iterable<String> elements, int width, Justification justification, boolean naEncode) {
        ArrayList<String> justified = Lists.newArrayList();
        for (String element : elements) {
            if (StringVector.isNA(element) && !naEncode) {
                justified.add(element);
                continue;
            }
            String padding = Text.padding(Math.max(0, width - Text.stringWidth(element)));
            if (justification == Justification.LEFT) {
                justified.add(element + padding);
                continue;
            }
            justified.add(padding + element);
        }
        return justified;
    }

    private static String padding(int count) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i != count; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    private static List<String> formatNumericalElements(AtomicVector x) {
        DecimalFormat format2 = new DecimalFormat();
        format2.setMinimumFractionDigits(0);
        format2.setGroupingUsed(false);
        ArrayList<String> strings = Lists.newArrayList();
        for (int i = 0; i != x.length(); ++i) {
            if (x.isElementNA(i)) {
                strings.add("NA");
                continue;
            }
            strings.add(format2.format(x.getElementAsDouble(i)));
        }
        return strings;
    }

    private static List<String> formatLogicalElements(AtomicVector x) {
        ArrayList<String> strings = Lists.newArrayList();
        for (int i = 0; i != x.length(); ++i) {
            if (x.isElementNA(i)) {
                strings.add("NA");
                continue;
            }
            strings.add(x.isElementTrue(i) ? "TRUE" : "FALSE");
        }
        return strings;
    }

    private static List<String> formatCharacterElements(AtomicVector x, boolean naEncode) {
        ArrayList<String> strings = Lists.newArrayList();
        for (int i = 0; i != x.length(); ++i) {
            if (x.isElementNA(i) && naEncode) {
                strings.add("NA");
                continue;
            }
            strings.add(x.getElementAsString(i));
        }
        return strings;
    }

    @Internal
    public static IntVector utf8ToInt(String x) {
        if (StringVector.isNA(x)) {
            return new IntArrayVector(Integer.MIN_VALUE);
        }
        IntArrayVector.Builder codePoints = new IntArrayVector.Builder(x.length());
        for (int i = 0; i != x.length(); ++i) {
            codePoints.set(i, x.codePointAt(i));
        }
        return codePoints.build();
    }

    @Internal
    public static StringVector intToUtf8(AtomicVector x, boolean multiple) {
        if (multiple) {
            StringVector.Builder chars = new StringVector.Builder(x.length());
            for (int i = 0; i != x.length(); ++i) {
                if (x.isElementNA(i)) {
                    chars.setNA(i);
                    continue;
                }
                int codePoint = x.getElementAsInt(i);
                if (codePoint == 0) {
                    chars.set(i, "");
                    continue;
                }
                chars.set(i, new String(new int[]{codePoint}, 0, 1));
            }
            return chars.build();
        }
        if (x.containsNA()) {
            return StringVector.valueOf(StringVector.NA);
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i != x.length(); ++i) {
            int codePoint;
            if (x.isElementNA(i)) {
                // empty if block
            }
            if ((codePoint = x.getElementAsInt(i)) == 0) continue;
            result.appendCodePoint(codePoint);
        }
        return StringVector.valueOf(result.toString());
    }

    @DataParallel
    @Internal(value="substr<-")
    public static String setSubstring(String s, int start, int stop2, String replace) {
        return s.substring(0, start - 1) + replace + s.substring(Math.min(stop2, start - 1 + replace.length()));
    }

    @Internal
    public static Vector iconv(@InvokeAsCharacter Vector x, String from, String to, String sub2, boolean mark, boolean toRaw) {
        if (x == Null.INSTANCE) {
            StringVector.Builder encodings = new StringVector.Builder();
            for (Charset charset : Charset.availableCharsets().values()) {
                encodings.add(charset.name().toUpperCase());
            }
            return encodings.build();
        }
        if (toRaw) {
            Charset destCharSet = RCharsets.getByName(to);
            ListVector.Builder result = new ListVector.Builder();
            for (int i = 0; i != x.length(); ++i) {
                result.add(new RawVector(x.getElementAsString(i).getBytes(destCharSet)));
            }
            return result.build();
        }
        return x;
    }

    @Internal
    @DataParallel(value=PreserveAttributeStyle.NONE)
    public static int strtoi(@Recycle String x, @Recycle(value=false) int base) {
        if (x.isEmpty()) {
            return 0;
        }
        if (base == 0) {
            if (x.startsWith("0x") || x.startsWith("0X")) {
                return Integer.parseInt(x.substring(2), 16);
            }
            if (x.startsWith("0")) {
                return Integer.parseInt(x, 8);
            }
            return Integer.parseInt(x, 10);
        }
        if (base == 16 && (x.startsWith("0x") || x.startsWith("0X"))) {
            return Integer.parseInt(x.substring(2), 16);
        }
        return Integer.parseInt(x, base);
    }

    static enum Justification {
        LEFT,
        RIGHT;

    }

    private static class StringElementAt
    implements Function<SEXP, String> {
        private int index;

        private StringElementAt(int index) {
            this.index = index;
        }

        @Override
        public String apply(SEXP input) {
            if (input.length() == 0) {
                return "";
            }
            if (input instanceof AtomicVector) {
                AtomicVector vector2 = (AtomicVector)input;
                String elementValue = vector2.getElementAsString(this.index % input.length());
                if (StringVector.isNA(elementValue)) {
                    return "NA";
                }
                return elementValue;
            }
            if (input instanceof ListVector) {
                SEXP element = ((ListVector)input).getElementAsSEXP(this.index % input.length());
                return this.listElementToString(element);
            }
            throw new EvalException(String.format("Cannot coerce argument of type '%s' to character.", input.getTypeName()), new Object[0]);
        }

        private String listElementToString(SEXP element) {
            if (element.length() == 1 && element instanceof AtomicVector) {
                return ((AtomicVector)element).getElementAsString(0);
            }
            return Deparse.deparseExp(null, element);
        }
    }
}

