/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.primitives.subset.IndexIterator;
import org.renjin.primitives.subset.IndexSubscript;
import org.renjin.primitives.subset.ListSubsetting;
import org.renjin.primitives.subset.SelectionStrategy;
import org.renjin.primitives.subset.Subscript;
import org.renjin.primitives.subset.SubsetAssertions;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListBuilder;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

class VectorIndexSelection
implements SelectionStrategy {
    private final AtomicVector subscript;

    public VectorIndexSelection(AtomicVector subscript) {
        this.subscript = subscript;
    }

    @Override
    public SEXP getVectorSubset(Context context, Vector source, boolean drop2) {
        return VectorIndexSelection.buildSelection(source, new IndexSubscript(this.subscript, source.length()), drop2);
    }

    public static Vector buildSelection(Vector source, Subscript subscript, boolean drop2) {
        int index;
        IndexIterator it = subscript.computeIndexes();
        Vector.Builder result = source.getVectorType().newBuilder();
        AtomicVector sourceNames = source.getNames();
        StringVector.Builder resultNames = null;
        if (sourceNames instanceof StringVector) {
            resultNames = new StringVector.Builder();
        }
        while ((index = it.next()) != -1) {
            if (IntVector.isNA(index) || index >= source.length()) {
                result.addNA();
                if (resultNames == null) continue;
                resultNames.addNA();
                continue;
            }
            result.addFrom(source, index);
            if (resultNames == null) continue;
            resultNames.add(sourceNames.getElementAsString(index));
        }
        if (VectorIndexSelection.isOneDimensionalArray(source) && (!drop2 || result.length() > 1)) {
            result.setAttribute(Symbols.DIM, (SEXP)new IntArrayVector(result.length()));
            if (resultNames != null) {
                result.setAttribute(Symbols.DIMNAMES, (SEXP)new ListVector(resultNames.build()));
            }
        } else if (resultNames != null) {
            result.setAttribute(Symbols.NAMES, (SEXP)resultNames.build());
        }
        return result.build();
    }

    @Override
    public SEXP getSingleListElement(ListVector source, boolean exact) {
        if (this.subscript.isElementNA(0)) {
            return Null.INSTANCE;
        }
        IndexSubscript subscript = new IndexSubscript(this.subscript, source.length());
        int index = subscript.computeUniqueIndex();
        if (IntVector.isNA(index)) {
            return Null.INSTANCE;
        }
        SubsetAssertions.checkBounds(source, index);
        return source.getElementAsSEXP(index);
    }

    @Override
    public AtomicVector getSingleAtomicVectorElement(AtomicVector source, boolean exact) {
        IndexSubscript subscript = new IndexSubscript(this.subscript, source.length());
        int index = subscript.computeUniqueIndex();
        SubsetAssertions.checkBounds(source, index);
        return (AtomicVector)source.getElementAsSEXP(index);
    }

    @Override
    public SEXP replaceSinglePairListElement(PairList.Node list2, SEXP replacement) {
        return this.replaceSingeListOrPairListElement(list2.newCopyBuilder(), replacement);
    }

    @Override
    public ListVector replaceSingleListElement(ListVector source, SEXP replacement) {
        return (ListVector)this.replaceSingeListOrPairListElement(source.newCopyNamedBuilder(), replacement);
    }

    private SEXP replaceSingeListOrPairListElement(ListBuilder result, SEXP replacement) {
        int selectedIndex = new IndexSubscript(this.subscript, result.length()).computeUniqueIndex();
        boolean deleting = replacement == Null.INSTANCE;
        boolean exists2 = selectedIndex < result.length();
        boolean deformed = false;
        if (deleting) {
            if (exists2) {
                result.remove(selectedIndex);
                deformed = true;
            }
        } else if (exists2) {
            result.set(selectedIndex, replacement);
        } else {
            result.set(selectedIndex, replacement);
            deformed = true;
        }
        if (deformed) {
            result.removeAttribute(Symbols.DIM);
            result.removeAttribute(Symbols.DIMNAMES);
        }
        return result.build();
    }

    @Override
    public Vector replaceSingleElement(Context context, AtomicVector source, Vector replacement) {
        if (replacement.length() == 0) {
            throw new EvalException("replacement has length zero", new Object[0]);
        }
        IndexSubscript subscript = new IndexSubscript(this.subscript, source.length());
        subscript.computeUniqueIndex();
        return VectorIndexSelection.buildReplacement(context, source, replacement, subscript);
    }

    @Override
    public ListVector replaceListElements(Context context, ListVector source, Vector replacements) {
        IndexSubscript subscript = new IndexSubscript(this.subscript, source.length());
        if (replacements == Null.INSTANCE) {
            return ListSubsetting.removeListElements(source, subscript.computeIndexPredicate());
        }
        return (ListVector)VectorIndexSelection.buildReplacement(context, source, replacements, subscript);
    }

    @Override
    public Vector replaceAtomicVectorElements(Context context, AtomicVector source, Vector replacements) {
        return VectorIndexSelection.buildReplacement(context, source, replacements, new IndexSubscript(this.subscript, source.length()));
    }

    public static Vector buildReplacement(Context context, Vector source, Vector replacements, Subscript subscript) {
        int index;
        source = context.materialize(source);
        replacements = context.materialize(replacements);
        Vector.Builder builder = source.newCopyBuilder(replacements.getVectorType());
        AtomicVector sourceNames = source.getNames();
        StringVector.Builder resultNames = null;
        if (sourceNames instanceof StringVector) {
            resultNames = ((StringVector)sourceNames).newCopyBuilder();
        }
        boolean deformed = false;
        int replacementIndex = 0;
        int replacementLength = replacements.length();
        IndexIterator it = subscript.computeIndexes();
        while ((index = it.next()) != -1) {
            if (index >= source.length()) {
                deformed = true;
                if (resultNames != null) {
                    while (resultNames.length() <= index) {
                        resultNames.add("");
                    }
                }
            }
            if (replacementLength == 0) {
                throw new EvalException("replacement has zero length", new Object[0]);
            }
            builder.setFrom(index, replacements, replacementIndex++);
            if (replacementIndex < replacementLength) continue;
            replacementIndex = 0;
        }
        if (deformed) {
            if (resultNames != null) {
                builder.setAttribute(Symbols.NAMES, (SEXP)resultNames.build());
            }
            builder.removeAttribute(Symbols.DIM);
            builder.removeAttribute(Symbols.DIMNAMES);
        }
        return builder.build();
    }

    private static boolean isOneDimensionalArray(Vector source) {
        return source.getAttributes().getDim().length() == 1;
    }
}

