/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io.connections;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.renjin.eval.EvalException;
import org.renjin.primitives.io.connections.AbstractConnection;
import org.renjin.primitives.io.connections.Connection;
import org.renjin.primitives.io.connections.OpenSpec;

public class UrlConnection
extends AbstractConnection {
    private final URL url;
    private InputStream in;
    private OpenSpec openSpec = new OpenSpec("r");

    public UrlConnection(URL url2) {
        this.url = url2;
    }

    public UrlConnection(URL url2, Charset charset) {
        super(charset);
        this.url = url2;
    }

    @Override
    public void open(OpenSpec spec) throws IOException {
        this.openSpec = spec;
        if (spec.forWriting()) {
            throw new EvalException("Cannot open url connection for writing", new Object[0]);
        }
        if (spec.isText()) {
            this.getReader();
        } else {
            this.getInputStream();
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            this.in = this.url.openStream();
        }
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new EvalException("Cannot open URL for output", new Object[0]);
    }

    @Override
    public boolean isOpen() {
        return this.in != null;
    }

    @Override
    protected void closeInputIfOpen() throws IOException {
        this.in.close();
    }

    @Override
    protected void closeOutputIfOpen() throws IOException {
    }

    @Override
    public String getClassName() {
        return "url";
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public String getDescription() {
        return this.url.toExternalForm();
    }

    @Override
    public Connection.Type getType() {
        return this.openSpec.getType();
    }
}

