/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.files;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.DataParallel;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.Invisible;
import org.renjin.invoke.annotations.PreserveAttributeStyle;
import org.renjin.invoke.annotations.Recycle;
import org.renjin.primitives.files.FileScanner;
import org.renjin.primitives.text.regex.ExtendedRE;
import org.renjin.primitives.text.regex.REFactory;
import org.renjin.primitives.text.regex.RESyntaxException;
import org.renjin.repackaged.guava.base.Strings;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.io.ByteStreams;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Files {
    public static final int CHECK_ACCESS_EXISTENCE = 0;
    public static final int CHECK_ACCESS_EXECUTE = 1;
    public static final int CHECK_ACCESS_WRITE = 2;
    public static final int CHECK_ACCESS_READ = 3;

    private Files() {
    }

    @DataParallel
    @Internal(value="path.expand")
    public static String pathExpand(String path2) {
        if (path2.length() < 2 || path2.charAt(0) != '~' || Character.isAlphabetic(path2.charAt(1))) {
            return path2;
        }
        String home2 = System.getenv("R_USER");
        if (home2 == null) {
            home2 = System.getProperty("user.home");
        }
        if (home2 == null) {
            return path2;
        }
        return home2 + path2.substring(1);
    }

    @Internal(value="file.access")
    public static IntVector fileAccess(@Current Context context, StringVector names2, int mode) throws FileSystemException {
        IntArrayVector.Builder result = new IntArrayVector.Builder();
        for (String name : names2) {
            FileObject file2 = context.resolveFile(Files.pathExpand(name));
            result.add(Files.checkAccess(file2, mode));
        }
        result.setAttribute(Symbols.NAMES, (SEXP)new StringArrayVector(names2.toArray()));
        return result.build();
    }

    private static int checkAccess(FileObject file2, int mode) throws FileSystemException {
        boolean ok = true;
        if ((mode & 0) != 0 && !file2.exists()) {
            ok = false;
        }
        if ((mode & 3) != 0 && !file2.isReadable()) {
            ok = false;
        }
        if ((mode & 2) != 0 & !file2.isWriteable()) {
            ok = false;
        }
        return ok ? 0 : -1;
    }

    @Internal(value="file.info")
    public static ListVector fileInfo(@Current Context context, StringVector paths) throws FileSystemException {
        DoubleArrayVector.Builder size = new DoubleArrayVector.Builder();
        LogicalArrayVector.Builder isdir = new LogicalArrayVector.Builder();
        IntArrayVector.Builder mode = new IntArrayVector.Builder().setAttribute(Symbols.CLASS, (SEXP)StringVector.valueOf("octmode"));
        DoubleArrayVector.Builder mtime = new DoubleArrayVector.Builder();
        StringVector.Builder exe = new StringVector.Builder();
        for (String path2 : paths) {
            if (StringVector.isNA(path2)) {
                throw new EvalException("invalid filename argument", new Object[0]);
            }
            FileObject file2 = context.resolveFile(path2);
            if (file2.exists()) {
                if (file2.getType() == FileType.FILE) {
                    size.add((int)file2.getContent().getSize());
                } else {
                    size.add(0.0);
                }
                isdir.add(file2.getType() == FileType.FOLDER);
                mode.add(Files.mode(file2));
                try {
                    mtime.add(file2.getContent().getLastModifiedTime());
                }
                catch (Exception e) {
                    mtime.add(0.0);
                }
                exe.add(file2.getName().getBaseName().endsWith(".exe") ? "yes" : "no");
                continue;
            }
            size.addNA();
            isdir.addNA();
            mode.addNA();
            mtime.addNA();
            exe.addNA();
        }
        return ListVector.newNamedBuilder().add("size", size).add("isdir", isdir).add("mode", mode).add("mtime", mtime).add("ctime", mtime).add("atime", mtime).add("exe", exe).build();
    }

    @Internal
    @DataParallel
    public static String normalizePath(@Current Context context, @Recycle String path2, String winSlash, SEXP mustWork) {
        boolean errorIfInvalid = false;
        boolean warningIfInvalid = false;
        if (mustWork instanceof AtomicVector && mustWork.length() >= 1) {
            errorIfInvalid = ((AtomicVector)mustWork).isElementTrue(0);
            warningIfInvalid = ((AtomicVector)mustWork).isElementNA(0);
        }
        try {
            return Files.friendlyFileName(context.resolveFile(path2));
        }
        catch (FileSystemException e) {
            if (errorIfInvalid) {
                throw new EvalException(e.getMessage(), new Object[0]);
            }
            if (warningIfInvalid) {
                context.warn(e.getMessage());
            }
            return path2;
        }
    }

    private static int mode(FileObject file2) throws FileSystemException {
        int access2 = 0;
        if (file2.isReadable()) {
            access2 += 4;
        }
        if (file2.isWriteable()) {
            access2 += 2;
        }
        if (file2.getType() == FileType.FOLDER) {
            ++access2;
        }
        String digit = Integer.toString(access2);
        String octalString = digit + digit + digit;
        return Integer.parseInt(octalString, 8);
    }

    @Internal(value="file.exists")
    @DataParallel(value=PreserveAttributeStyle.NONE, passNA=true)
    public static boolean fileExists(@Current Context context, String path2) throws FileSystemException {
        if (path2 == null) {
            return false;
        }
        return context.resolveFile(path2).exists();
    }

    @Internal
    @DataParallel
    public static String basename(String path2) {
        for (int i = path2.length() - 1; i >= 0; --i) {
            if (path2.charAt(i) != '\\' && path2.charAt(i) != '/') continue;
            return path2.substring(i + 1);
        }
        return path2;
    }

    @Internal(value="Sys.glob")
    public static StringVector glob(@Current Context context, StringVector paths, boolean markDirectories) {
        ArrayList<String> matching = Lists.newArrayList();
        for (String path2 : paths) {
            if (path2 == null) continue;
            if (path2.indexOf(42) == -1) {
                matching.add(path2);
                continue;
            }
            matching.addAll(FileScanner.scan(context, path2, markDirectories));
        }
        return new StringArrayVector((Collection<String>)matching);
    }

    private static boolean isWindows() {
        String operatingSystem = Strings.nullToEmpty(System.getProperty("os.name")).toLowerCase();
        return operatingSystem.contains("win");
    }

    @Internal(value="Sys.which")
    public static StringVector sysWhich(@Current Context context, StringVector names2) {
        if (Files.isWindows()) {
            throw new EvalException("Sys.which() not implemented for Windows", new Object[0]);
        }
        String[] path2 = Strings.nullToEmpty(System.getenv("PATH")).split(File.pathSeparator);
        StringVector.Builder result = new StringVector.Builder(0, names2.length());
        result.setAttribute(Symbols.NAMES, names2.setAttributes(AttributeMap.EMPTY));
        for (String name : names2) {
            result.add(Files.findExecutable(context, path2, name));
        }
        return result.build();
    }

    private static String findExecutable(Context context, String[] paths, String name) {
        if (Files.isAbsolutePath(name)) {
            return Files.executablePath(context, name);
        }
        for (String path2 : paths) {
            String executablePath = Files.executablePath(context, path2 + File.separator + name);
            if (executablePath.isEmpty()) continue;
            return executablePath;
        }
        return "";
    }

    private static String executablePath(Context context, String name) {
        try {
            FileObject fileObject = context.resolveFile(name);
            if (fileObject.exists()) {
                return Files.friendlyFileName(fileObject);
            }
            return "";
        }
        catch (FileSystemException e) {
            return "";
        }
    }

    private static boolean isAbsolutePath(String name) {
        File file2 = new File(name);
        return file2.isAbsolute();
    }

    @Internal
    @DataParallel
    public static String dirname(String path2) {
        for (int i = path2.length() - 1; i >= 0; --i) {
            if (path2.charAt(i) != '\\' && path2.charAt(i) != '/') continue;
            return path2.substring(0, i);
        }
        return ".";
    }

    @Internal(value="dir.create")
    public static SEXP dirCreate(@Current Context context, String path2, boolean showWarnings, boolean recursive2, int mode) throws FileSystemException {
        FileObject dir2 = context.resolveFile(path2);
        dir2.createFolder();
        context.setInvisibleFlag();
        return new LogicalArrayVector(true);
    }

    @DataParallel(value=PreserveAttributeStyle.NONE, passNA=true)
    @Internal(value="dir.exists")
    public static boolean dirExists(@Current Context context, String uri) throws FileSystemException {
        if (uri == null) {
            return false;
        }
        FileObject fileObject = context.resolveFile(uri);
        return fileObject.exists() && fileObject.getType() == FileType.FOLDER;
    }

    @Internal(value="list.files")
    public static StringVector listFiles(final @Current Context context, final StringVector paths, final String pattern, final boolean allFiles, final boolean fullNames, final boolean recursive2, final boolean ignoreCase, final boolean includeDirs) throws IOException {
        return new Object(){
            private final List<String> result = new ArrayList<String>();
            private Predicate<String> nameFilter;

            public StringVector list() throws IOException {
                if (pattern == null) {
                    this.nameFilter = x -> true;
                } else {
                    try {
                        this.nameFilter = REFactory.asPredicate(new ExtendedRE(pattern).ignoreCase(ignoreCase));
                    }
                    catch (RESyntaxException e) {
                        throw new EvalException("Invalid pattern '%s': %s", pattern, e.getMessage());
                    }
                }
                for (String path2 : paths) {
                    FileObject folder = context.resolveFile(path2);
                    if (folder.getType() != FileType.FOLDER) continue;
                    String rootPrefix = fullNames ? folder.getName().getPath() : "";
                    this.list(rootPrefix, folder);
                }
                Collections.sort(this.result);
                return new StringArrayVector((Collection<String>)this.result);
            }

            private void list(String path2, FileObject folder) throws FileSystemException {
                if (allFiles && !recursive2) {
                    if (this.nameFilter.test(".")) {
                        this.add(path2, ".");
                    }
                    if (this.nameFilter.test("..")) {
                        this.add(path2, "..");
                    }
                }
                for (FileObject child : folder.getChildren()) {
                    if (this.filter(child)) {
                        this.add(path2, child);
                    }
                    if (!recursive2 || child.getType() != FileType.FOLDER) continue;
                    this.list(this.qualify(path2, child.getName().getBaseName()), child);
                }
            }

            void add(String path2, FileObject file2) throws FileSystemException {
                this.add(path2, file2.getName().getBaseName());
            }

            void add(String path2, String name) throws FileSystemException {
                this.result.add(this.qualify(path2, name));
            }

            private String qualify(String path2, String filename) {
                if (path2.length() > 0) {
                    return path2 + "/" + filename;
                }
                return filename;
            }

            boolean filter(FileObject child) throws FileSystemException {
                if (!allFiles && this.isHidden(child)) {
                    return false;
                }
                if (recursive2 && !includeDirs && child.getType() == FileType.FOLDER) {
                    return false;
                }
                return this.nameFilter.test(child.getName().getBaseName());
            }

            private boolean isHidden(FileObject file2) throws FileSystemException {
                return file2.isHidden() || file2.getName().getBaseName().startsWith(".");
            }
        }.list();
    }

    @Internal
    public static String tempdir() {
        return System.getProperty("java.io.tmpdir");
    }

    @Internal
    @DataParallel
    public static String tempfile(String pattern, String tempdir2, String fileExt) {
        return tempdir2 + "/" + pattern + Files.createRandomHexString(10) + fileExt;
    }

    private static String createRandomHexString(int length2) {
        Random randomService = new Random();
        String sb = "";
        while (sb.length() < length2) {
            sb = sb + Integer.toHexString(randomService.nextInt());
        }
        return sb;
    }

    @Internal
    public static String getwd(@Current Context context) {
        return Files.friendlyFileName(context.getSession().getWorkingDirectory());
    }

    @Invisible
    @Internal
    public static String setwd(@Current Context context, String workingDirectoryName) throws FileSystemException {
        FileObject newWorkingDirectory = context.resolveFile(workingDirectoryName);
        if (!newWorkingDirectory.exists() || newWorkingDirectory.getType() != FileType.FOLDER) {
            throw new EvalException("cannot change working directory", new Object[0]);
        }
        String previous = Files.friendlyFileName(context.getSession().getWorkingDirectory());
        context.getSession().setWorkingDirectory(newWorkingDirectory);
        return previous;
    }

    @Internal
    public static IntVector unlink(@Current Context context, StringVector paths, boolean recursive2, boolean force) throws FileSystemException {
        IntArrayVector.Builder result = new IntArrayVector.Builder();
        for (String path2 : paths) {
            if (StringVector.isNA(path2)) {
                result.add(0);
                continue;
            }
            FileObject file2 = context.resolveFile(path2);
            Files.delete(file2, recursive2);
            result.add(1);
        }
        return result.build();
    }

    @Internal(value="local.file")
    public static StringVector localFile(@Current Context context, StringVector uris) throws IOException {
        StringVector.Builder localFiles = new StringVector.Builder(0, uris.length());
        for (String uri : uris) {
            FileObject fileObject = context.resolveFile(uri);
            File localFile = fileObject.getFileSystem().replicateFile(fileObject, (FileSelector)new AllFileSelector());
            localFiles.add(localFile.getAbsolutePath());
        }
        return localFiles.build();
    }

    private static void delete(FileObject file2, boolean recursive2) throws FileSystemException {
        if (file2.exists()) {
            if (file2.getType() == FileType.FILE) {
                file2.delete();
            } else if (file2.getType() == FileType.FOLDER) {
                if (file2.getChildren().length == 0) {
                    file2.delete();
                } else if (recursive2) {
                    file2.delete((FileSelector)new AllFileSelector());
                    file2.delete();
                }
            }
        }
    }

    @Internal(value="file.copy")
    public static LogicalVector fileCopy(@Current Context context, StringVector fromFiles, String to, boolean overwrite, final boolean recursive2) throws FileSystemException {
        LogicalArrayVector.Builder result = new LogicalArrayVector.Builder();
        FileObject toFile = context.resolveFile(to);
        for (String from : fromFiles) {
            try {
                toFile.copyFrom(context.resolveFile(from), new FileSelector(){

                    public boolean traverseDescendents(FileSelectInfo fileInfo) throws Exception {
                        return true;
                    }

                    public boolean includeFile(FileSelectInfo fileInfo) throws Exception {
                        return recursive2;
                    }
                });
                result.add(true);
            }
            catch (FileSystemException e) {
                result.add(false);
            }
        }
        return result.build();
    }

    @Internal(value="file.rename")
    public static LogicalVector fileRename(@Current Context context, StringVector fromFiles, StringVector toFiles) throws FileSystemException {
        if (toFiles.length() != fromFiles.length()) {
            throw new EvalException("'from' and 'to' are of different lengths", new Object[0]);
        }
        LogicalArrayVector.Builder result = new LogicalArrayVector.Builder();
        for (int i = 0; i < fromFiles.length(); ++i) {
            boolean succeeded = Files.renameFile(context, fromFiles.getElementAsString(i), toFiles.getElementAsString(i));
            result.add(succeeded);
        }
        return result.build();
    }

    private static boolean renameFile(@Current Context context, String fromUri, String toUri) {
        try {
            FileObject from = context.resolveFile(fromUri);
            if (!from.exists()) {
                throw new FileSystemException("No such file or directory");
            }
            FileObject to = context.resolveFile(toUri);
            if (!from.canRenameTo(to)) {
                throw new FileSystemException("rename not supported");
            }
            from.moveTo(to);
            return true;
        }
        catch (FileSystemException e) {
            context.warn(String.format("cannot rename file '%s' to '%s', reason: '%s'", fromUri, toUri, e.getMessage()));
            return false;
        }
    }

    @Internal(value="file.remove")
    public static LogicalVector fileRemove(@Current Context context, StringVector files2) throws FileSystemException {
        LogicalArrayVector.Builder result = new LogicalArrayVector.Builder();
        for (int i = 0; i < files2.length(); ++i) {
            boolean succeeded = Files.removeFile(context, files2.getElementAsString(i));
            result.add(succeeded);
        }
        return result.build();
    }

    private static boolean removeFile(@Current Context context, String file2) {
        try {
            FileObject fileObject = context.resolveFile(file2);
            if (!fileObject.exists()) {
                throw new FileSystemException("No such file or directory");
            }
            return fileObject.delete();
        }
        catch (FileSystemException e) {
            context.warn(String.format("cannot remove file '%s', reason: '%s'", file2, e.getMessage()));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public static SEXP unzip(@Current Context context, String zipFile, Vector files2, String exdirUri, boolean list2, boolean overwrite, boolean junkpaths) throws IOException {
        try (ZipInputStream zin = new ZipInputStream(context.resolveFile(Files.pathExpand(zipFile)).getContent().getInputStream());){
            ZipEntry entry;
            FileObject exdir = context.resolveFile(exdirUri);
            if (list2) {
                throw new EvalException("unzip(list=true) not yet implemented", new Object[0]);
            }
            while ((entry = zin.getNextEntry()) != null) {
                if (!Files.unzipMatches(entry, files2)) continue;
                Files.unzipExtract(zin, entry, exdir, junkpaths, overwrite);
            }
            context.setInvisibleFlag();
            IntArrayVector intArrayVector = new IntArrayVector(0);
            return intArrayVector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzipExtract(ZipInputStream zin, ZipEntry entry, FileObject exdir, boolean junkpaths, boolean overwrite) throws IOException {
        if (junkpaths) {
            throw new EvalException("unzip(junpaths=false) not yet implemented", new Object[0]);
        }
        FileObject exfile = exdir.resolveFile(entry.getName());
        if (exfile.exists() && !overwrite) {
            throw new EvalException("file to be extracted '%s' already exists", Files.friendlyFileName(exfile));
        }
        try (OutputStream out = exfile.getContent().getOutputStream();){
            int bytesRead;
            byte[] buffer = new byte[65536];
            while ((bytesRead = zin.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
        }
    }

    private static String friendlyFileName(FileObject file2) {
        String uri = file2.getName().getURI();
        if (uri.startsWith("file://")) {
            return uri.substring("file://".length());
        }
        return uri;
    }

    private static boolean unzipMatches(ZipEntry entry, Vector files2) {
        if (files2 == Null.INSTANCE) {
            return true;
        }
        for (int i = 0; i != files2.length(); ++i) {
            if (!entry.getName().equals(files2.getElementAsString(i))) continue;
            return true;
        }
        return false;
    }

    @Internal(value="file.create")
    @DataParallel
    public static boolean fileCreate(@Current Context context, @Recycle String fileName, @Recycle(value=false) boolean showWarnings) throws IOException {
        try {
            FileObject file2 = context.resolveFile(fileName);
            if (!file2.getParent().exists()) {
                throw new IOException("No such file or directory");
            }
            file2.getContent().getOutputStream().close();
            return true;
        }
        catch (Exception e) {
            if (showWarnings) {
                context.warn(String.format("cannot create file '%s', reason '%s'", fileName, e.getMessage()));
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal(value="file.append")
    @DataParallel
    public static boolean fileAppend(@Current Context context, String destFileName, String sourceFileName) {
        try {
            FileObject sourceFile = context.resolveFile(sourceFileName);
            if (!sourceFile.exists()) {
                return false;
            }
            FileObject destFile = context.resolveFile(destFileName);
            OutputStream out = destFile.getContent().getOutputStream(true);
            try {
                InputStream in = sourceFile.getContent().getInputStream();
                try {
                    ByteStreams.copy(in, out);
                }
                finally {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

