/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.combine.view;

import org.renjin.primitives.combine.CombinedNames;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.Null;
import org.renjin.sexp.StringVector;

public class PrefixedNameVector
extends StringVector {
    private String prefix;
    private AtomicVector namesVector;
    private int length;
    private boolean numberUnnamedElements;

    public PrefixedNameVector(String prefix, AtomicVector namesVector, boolean numberUnnamedElements, AttributeMap attributes2) {
        super(attributes2);
        this.numberUnnamedElements = numberUnnamedElements;
        this.prefix = prefix;
        this.namesVector = namesVector;
    }

    @Override
    public int length() {
        return this.namesVector.length();
    }

    @Override
    protected StringVector cloneWithNewAttributes(AttributeMap attributes2) {
        return new PrefixedNameVector(this.prefix, this.namesVector, this.numberUnnamedElements, attributes2);
    }

    @Override
    public String getElementAsString(int index) {
        String name = "";
        if (this.namesVector != Null.INSTANCE) {
            name = this.namesVector.getElementAsString(index);
        }
        if (CombinedNames.isPresent(name)) {
            return CombinedNames.toString(this.prefix) + "." + CombinedNames.toString(name);
        }
        if (this.numberUnnamedElements) {
            return CombinedNames.toString(this.prefix) + Integer.toString(index + 1);
        }
        return this.prefix;
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }
}

