/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import org.apache.commons.math.complex.Complex;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Cast;
import org.renjin.invoke.annotations.CastStyle;
import org.renjin.invoke.annotations.DataParallel;
import org.renjin.invoke.annotations.Deferrable;
import org.renjin.invoke.annotations.DownCastComplex;
import org.renjin.invoke.annotations.Generic;
import org.renjin.invoke.annotations.GroupGeneric;
import org.renjin.invoke.annotations.PreserveAttributeStyle;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.Vector;

@GroupGeneric
public class Ops {
    private Ops() {
    }

    @Deferrable
    @Builtin(value="+")
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double plus(double x, double y) {
        return x + y;
    }

    @Deferrable
    @Builtin(value="+")
    @DataParallel(value=PreserveAttributeStyle.ALL)
    public static int plus(@Cast(value=CastStyle.EXPLICIT) int a, @Cast(value=CastStyle.EXPLICIT) int b) {
        try {
            return Math.addExact(a, b);
        }
        catch (ArithmeticException e) {
            return Integer.MIN_VALUE;
        }
    }

    @Builtin(value="+")
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static Complex plus(Complex x, Complex y) {
        return x.add(y);
    }

    @Deferrable
    @Builtin(value="+")
    public static Vector plus(Vector x) {
        return x;
    }

    @Deferrable
    @Builtin(value="-")
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double minus(double x, double y) {
        return x - y;
    }

    @Builtin(value="-")
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static Complex negative(Complex x) {
        return ComplexVector.complex(-x.getReal(), -x.getImaginary());
    }

    @Builtin(value="-")
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static Complex minus(Complex x, Complex y) {
        return new Complex(x.getReal() - y.getReal(), x.getImaginary() - y.getImaginary());
    }

    @Deferrable
    @Builtin(value="-")
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double minus(@Cast(value=CastStyle.EXPLICIT) double x) {
        return -x;
    }

    @Deferrable
    @Builtin(value="-")
    @DataParallel(value=PreserveAttributeStyle.ALL)
    public static int minus(@Cast(value=CastStyle.EXPLICIT) int x) {
        return -x;
    }

    @Deferrable
    @Builtin(value="-")
    @DataParallel(value=PreserveAttributeStyle.ALL)
    public static int minus(@Cast(value=CastStyle.EXPLICIT) int a, @Cast(value=CastStyle.EXPLICIT) int b) {
        try {
            return Math.subtractExact(a, b);
        }
        catch (ArithmeticException e) {
            return Integer.MIN_VALUE;
        }
    }

    @Deferrable
    @Builtin(value="/")
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double divide(double x, double y) {
        return x / y;
    }

    @Builtin(value="/")
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static Complex divide(Complex dividend, Complex divisor) {
        double y;
        double x;
        double denominator;
        double ratio;
        double a = dividend.getReal();
        double b = dividend.getImaginary();
        double c2 = divisor.getReal();
        double d = divisor.getImaginary();
        if (Math.abs(c2) < Math.abs(d)) {
            ratio = c2 / d;
            denominator = c2 * ratio + d;
            x = (a * ratio + b) / denominator;
            y = (b * ratio - a) / denominator;
        } else {
            ratio = d / c2;
            denominator = d * ratio + c2;
            x = (b * ratio + a) / denominator;
            y = (b - a * ratio) / denominator;
        }
        if (Double.isNaN(x) && Double.isNaN(y)) {
            if (!(c2 != 0.0 || d != 0.0 || Double.isNaN(a) && Double.isNaN(b))) {
                x = Math.copySign(Double.POSITIVE_INFINITY, c2) * a;
                y = Math.copySign(Double.POSITIVE_INFINITY, c2) * b;
            } else if ((Double.isInfinite(a) || Double.isInfinite(b)) && DoubleVector.isFinite(c2) && DoubleVector.isFinite(d)) {
                double ra = Ops.convertInf(a);
                double rb = Ops.convertInf(b);
                x = Double.POSITIVE_INFINITY * (ra * c2 + rb * d);
                y = Double.POSITIVE_INFINITY * (rb * c2 - ra * d);
            } else if ((Double.isInfinite(c2) || Double.isInfinite(d)) && DoubleVector.isFinite(a) && DoubleVector.isFinite(b)) {
                double rc = Ops.convertInf(c2);
                double rd = Ops.convertInf(d);
                x = 0.0 * (a * rc + b * rd);
                y = 0.0 * (b * rc - a * rd);
            }
        }
        return ComplexVector.complex(x, y);
    }

    @Deferrable
    @Builtin(value="*")
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double multiply(double x, double y) {
        return x * y;
    }

    @Deferrable
    @Builtin(value="*")
    @DataParallel(value=PreserveAttributeStyle.ALL)
    public static int multiply(@Cast(value=CastStyle.EXPLICIT) int x, @Cast(value=CastStyle.EXPLICIT) int y) {
        try {
            return Math.multiplyExact(x, y);
        }
        catch (ArithmeticException e) {
            return Integer.MIN_VALUE;
        }
    }

    @Builtin(value="*")
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static Complex multiply(Complex x, Complex y) {
        double a = x.getReal();
        double b = x.getImaginary();
        double c2 = y.getReal();
        double d = y.getImaginary();
        double ac = a * c2;
        double bd = b * d;
        double bc = b * c2;
        double ad = a * d;
        double real2 = ac - bd;
        double imag = bc + ad;
        if (Double.isNaN(real2) && Double.isNaN(imag)) {
            boolean recalc = false;
            double ra = a;
            double rb = b;
            double rc = c2;
            double rd = d;
            if (Double.isInfinite(ra) || Double.isInfinite(rb)) {
                ra = Ops.convertInf(ra);
                rb = Ops.convertInf(rb);
                rc = Ops.convertNaN(rc);
                rd = Ops.convertNaN(rd);
                recalc = true;
            }
            if (Double.isInfinite(rc) || Double.isInfinite(rd)) {
                rc = Ops.convertInf(rc);
                rd = Ops.convertInf(rd);
                ra = Ops.convertNaN(ra);
                rb = Ops.convertNaN(rb);
                recalc = true;
            }
            if (!recalc && (Double.isInfinite(ac) || Double.isInfinite(bd) || Double.isInfinite(ad) || Double.isInfinite(bc))) {
                ra = Ops.convertNaN(ra);
                rb = Ops.convertNaN(rb);
                rc = Ops.convertNaN(rc);
                rd = Ops.convertNaN(rd);
                recalc = true;
            }
            if (recalc) {
                real2 = Double.POSITIVE_INFINITY * (ra * rc - rb * rd);
                imag = Double.POSITIVE_INFINITY * (ra * rd + rb * rc);
            }
        }
        return ComplexVector.complex(real2, imag);
    }

    private static double convertNaN(double d) {
        if (Double.isNaN(d)) {
            return Math.copySign(0.0, d);
        }
        return d;
    }

    @Deferrable
    @Builtin(value="==")
    @DataParallel
    public static boolean equalTo(String x, String y) {
        return x.equals(y);
    }

    @Deferrable
    @Builtin(value="==")
    @DataParallel
    public static boolean equalTo(Complex x, Complex y) {
        return x.equals((Object)y);
    }

    @Deferrable
    @Builtin(value="==")
    @DataParallel
    public static boolean equalTo(double x, double y) {
        return x == y;
    }

    @Deferrable
    @Builtin(value="==")
    @DataParallel
    public static boolean equalTo(int x, int y) {
        return x == y;
    }

    @Deferrable
    @Builtin(value="==")
    @DataParallel
    public static boolean equalTo(boolean x, boolean y) {
        return x == y;
    }

    @Deferrable
    @Builtin(value="==")
    @DataParallel
    public static boolean equalTo(byte x, byte y) {
        return x == y;
    }

    @Deferrable
    @Builtin(value="!=")
    @DataParallel
    public static boolean notEqualTo(String x, String y) {
        return !x.equals(y);
    }

    @Deferrable
    @Builtin(value="!=")
    @DataParallel
    public static boolean notEqualTo(Complex x, Complex y) {
        return !x.equals((Object)y);
    }

    @Deferrable
    @Builtin(value="!=")
    @DataParallel
    public static boolean notEqualTo(double x, double y) {
        return x != y;
    }

    @Deferrable
    @Builtin(value="!=")
    @DataParallel
    public static boolean notEqualTo(int x, int y) {
        return x != y;
    }

    @Deferrable
    @Builtin(value="!=")
    @DataParallel
    public static boolean notEqualTo(boolean x, boolean y) {
        return x != y;
    }

    @Deferrable
    @Builtin(value="!=")
    @DataParallel
    public static boolean notEqualTo(byte x, byte y) {
        return x != y;
    }

    @Deferrable
    @Builtin(value="<")
    @DataParallel
    public static boolean lessThan(String x, String y) {
        return x.compareTo(y) < 0;
    }

    @Builtin(value="<")
    @DataParallel
    public static boolean lessThan(Complex x, Complex y) {
        throw new EvalException("invalid comparison with complex values", new Object[0]);
    }

    @Deferrable
    @Builtin(value="<")
    @DataParallel
    public static boolean lessThan(double x, double y) {
        return x < y;
    }

    @Deferrable
    @Builtin(value="<")
    @DataParallel
    public static boolean lessThan(int x, int y) {
        return x < y;
    }

    @Deferrable
    @Builtin(value="<")
    @DataParallel
    public static boolean lessThan(boolean x, boolean y) {
        return !x && y;
    }

    @Deferrable
    @Builtin(value="<")
    @DataParallel
    public static boolean lessThan(byte x, byte y) {
        return (x & 0xFF) < (y & 0xFF);
    }

    @Deferrable
    @Builtin(value="<=")
    @DataParallel
    public static boolean lessThanOrEqualTo(String x, String y) {
        return x.compareTo(y) <= 0;
    }

    @Builtin(value="<=")
    @DataParallel
    public static boolean lessThanOrEqualTo(Complex x, Complex y) {
        throw new EvalException("invalid comparison with complex values", new Object[0]);
    }

    @Deferrable
    @Builtin(value="<=")
    @DataParallel
    public static boolean lessThanOrEqualTo(double x, double y) {
        return x <= y;
    }

    @Deferrable
    @Builtin(value="<=")
    @DataParallel
    public static boolean lessThanOrEqualTo(int x, int y) {
        return x <= y;
    }

    @Deferrable
    @Builtin(value="<=")
    @DataParallel
    public static boolean lessThanOrEqualTo(boolean x, boolean y) {
        return y || !x;
    }

    @Deferrable
    @Builtin(value="<=")
    @DataParallel
    public static boolean lessThanOrEqualTo(byte x, byte y) {
        return (x & 0xFF) <= (y & 0xFF);
    }

    @Deferrable
    @Builtin(value=">")
    @DataParallel
    public static boolean greaterThan(String x, String y) {
        return x.compareTo(y) > 0;
    }

    @Builtin(value=">")
    @DataParallel
    public static boolean greaterThan(Complex x, Complex y) {
        throw new EvalException("invalid comparison with complex values", new Object[0]);
    }

    @Deferrable
    @Builtin(value=">")
    @DataParallel
    public static boolean greaterThan(double x, double y) {
        return x > y;
    }

    @Deferrable
    @Builtin(value=">")
    @DataParallel
    public static boolean greaterThan(int x, int y) {
        return x > y;
    }

    @Deferrable
    @Builtin(value=">")
    @DataParallel
    public static boolean greaterThan(boolean x, boolean y) {
        return x && !y;
    }

    @Deferrable
    @Builtin(value=">")
    @DataParallel
    public static boolean greaterThan(byte x, byte y) {
        return (x & 0xFF) > (y & 0xFF);
    }

    @Deferrable
    @Builtin(value=">=")
    @DataParallel
    public static boolean greaterThanOrEqual(String x, String y) {
        return x.compareTo(y) >= 0;
    }

    @Builtin(value=">=")
    @DataParallel
    public static boolean greaterThanOrEqual(Complex x, Complex y) {
        throw new EvalException("invalid comparison with complex values", new Object[0]);
    }

    @Deferrable
    @Builtin(value=">=")
    @DataParallel
    public static boolean greaterThanOrEqual(double x, double y) {
        return x >= y;
    }

    @Deferrable
    @Builtin(value=">=")
    @DataParallel
    public static boolean greaterThanOrEqual(int x, int y) {
        return x >= y;
    }

    @Deferrable
    @Builtin(value=">=")
    @DataParallel
    public static boolean greaterThanOrEqual(boolean x, boolean y) {
        return x || !y;
    }

    @Deferrable
    @Builtin(value=">=")
    @DataParallel
    public static boolean greaterThanOrEqual(byte x, byte y) {
        return (x & 0xFF) >= (y & 0xFF);
    }

    @Deferrable
    @Builtin(value="^")
    @DataParallel(value=PreserveAttributeStyle.ALL, passNA=true)
    public static double power(double a, double b) {
        if (b == 2.0) {
            return a * a;
        }
        if (a == 1.0 || b == 0.0) {
            return 1.0;
        }
        if (a == 0.0) {
            if (b > 0.0) {
                return 0.0;
            }
            if (b < 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            return b;
        }
        if (DoubleVector.isFinite(a) && DoubleVector.isFinite(b)) {
            return Math.pow(a, b);
        }
        if (Double.isNaN(a) || Double.isNaN(b)) {
            if (DoubleVector.isNA(a) || DoubleVector.isNA(b)) {
                return DoubleVector.NA;
            }
            return a + b;
        }
        if (!DoubleVector.isFinite(a)) {
            if (a > 0.0) {
                if (b < 0.0) {
                    return 0.0;
                }
                return Double.POSITIVE_INFINITY;
            }
            if (DoubleVector.isFinite(b) && b == Math.floor(b)) {
                if (b < 0.0) {
                    return 0.0;
                }
                return Ops.fmod(b, 2.0) != 0.0 ? a : -a;
            }
        }
        if (!DoubleVector.isFinite(b) && a >= 0.0) {
            if (b > 0.0) {
                return a >= 1.0 ? Double.POSITIVE_INFINITY : 0.0;
            }
            return a < 1.0 ? Double.POSITIVE_INFINITY : 0.0;
        }
        return Double.NaN;
    }

    @Deferrable
    @Builtin(value="^")
    @DataParallel(value=PreserveAttributeStyle.ALL)
    public static Complex power(Complex x, Complex y) {
        if (y.getImaginary() == 0.0) {
            double yr = y.getReal();
            if (yr == 0.0) {
                return ComplexVector.complex(1.0, 0.0);
            }
            if (yr == 1.0) {
                return x;
            }
            int k = (int)yr;
            if ((double)k == yr && k < 65536) {
                return Ops.power(x, k);
            }
        }
        return x.pow(y);
    }

    private static Complex power(Complex x, int k) {
        if (k < 0) {
            return Ops.reciprocal(Ops.power(x, -k));
        }
        Complex result = ComplexVector.complex(1.0, 0.0);
        while (k > 0) {
            result = Ops.multiply(result, x);
            --k;
        }
        return result;
    }

    private static Complex reciprocal(Complex value) {
        double y;
        double x;
        double denominator;
        double ratio;
        double c2 = value.getReal();
        double d = value.getImaginary();
        if (Math.abs(c2) < Math.abs(d)) {
            ratio = c2 / d;
            denominator = c2 * ratio + d;
            x = ratio / denominator;
            y = -1.0 / denominator;
        } else {
            ratio = d / c2;
            denominator = d * ratio + c2;
            x = 1.0 / denominator;
            y = -ratio / denominator;
        }
        if (Double.isNaN(x) && Double.isNaN(y)) {
            if (c2 == 0.0 && d == 0.0) {
                x = Math.copySign(Double.POSITIVE_INFINITY, c2);
                y = Math.copySign(Double.NaN, c2);
            } else if (Double.isInfinite(c2) || Double.isInfinite(d)) {
                double rc = Ops.convertInf(c2);
                double rd = Ops.convertInf(d);
                x = 0.0 * rc;
                y = 0.0 * -rd;
            }
        }
        return ComplexVector.complex(x, y);
    }

    public static double convertInf(double d) {
        return Math.copySign(Double.isInfinite(d) ? 1.0 : 0.0, d);
    }

    @Deferrable
    @Builtin(value="!")
    @DataParallel
    public static boolean not(boolean value) {
        return !value;
    }

    @Builtin(value="!")
    @DataParallel
    public static byte not(byte value) {
        return ~value;
    }

    @Deferrable
    @Builtin(value="%%")
    @DataParallel
    public static double modulus(double x, double y) {
        return Ops.fmod(x, y);
    }

    @Deferrable
    @Builtin(value="%%")
    @DataParallel
    public static int modulus(@Cast(value=CastStyle.EXPLICIT) int x, @Cast(value=CastStyle.EXPLICIT) int y) {
        if (y != 0) {
            if (x >= 0 && y > 0) {
                return x % y;
            }
            return (int)Ops.fmod(x, y);
        }
        return Integer.MIN_VALUE;
    }

    public static double fmod(double a, double b) {
        double quotient = a / b;
        if (b != 0.0) {
            double tmp = a - Math.floor(quotient) * b;
            if (!DoubleVector.isFinite(quotient) || Math.abs(quotient) > 4.503599727262001E15) {
                // empty if block
            }
            return tmp - Math.floor(tmp / b) * b;
        }
        return Double.NaN;
    }

    @Deferrable
    @Builtin(value="%/%")
    @DataParallel
    public static double integerDivision(double x, double y) {
        return Math.floor(x / y);
    }

    @Deferrable
    @Builtin(value="%/%")
    @DataParallel
    public static int integerDivision(@Cast(value=CastStyle.EXPLICIT) int x, @Cast(value=CastStyle.EXPLICIT) int y) {
        if (y != 0) {
            return (int)Math.floor((double)x / (double)y);
        }
        return Integer.MIN_VALUE;
    }

    @Generic
    @Deferrable
    @Builtin(value="&")
    @DataParallel(passNA=true)
    public static Logical and(@DownCastComplex double x, @DownCastComplex double y) {
        if (x == 0.0 || y == 0.0) {
            return Logical.FALSE;
        }
        if (DoubleVector.isNA(x) || DoubleVector.isNA(y)) {
            return Logical.NA;
        }
        return Logical.TRUE;
    }

    @Generic
    @Deferrable
    @Builtin(value="|")
    @DataParallel(passNA=true)
    public static Logical or(@DownCastComplex double x, @DownCastComplex double y) {
        if (x != 0.0 && !DoubleVector.isNA(x) || y != 0.0 && !DoubleVector.isNA(y)) {
            return Logical.TRUE;
        }
        if (x == 0.0 && y == 0.0) {
            return Logical.FALSE;
        }
        return Logical.NA;
    }

    @Generic
    @Builtin(value="|")
    @DataParallel
    public static byte or(byte x, byte y) {
        return (byte)(x | y);
    }

    @Generic
    @Builtin(value="&")
    @DataParallel
    public static byte and(byte x, byte y) {
        return (byte)(x & y);
    }
}

