/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import org.renjin.gcc.runtime.ObjectPtr;
import org.renjin.gcc.runtime.PointerPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.StringVector;

public class NativeStringVector
extends StringVector {
    private Ptr[] array;
    private int offset;
    private int length;

    public NativeStringVector(Ptr[] array2, int offset, int length2, AttributeMap attributes2) {
        super(attributes2);
        this.array = array2;
        this.offset = offset;
        this.length = length2;
    }

    public NativeStringVector(ObjectPtr ptr, AttributeMap attributes2) {
        super(attributes2);
        this.array = (Ptr[])ptr.array;
        this.offset = ptr.offset;
        this.length = ptr.array.length;
    }

    public NativeStringVector(PointerPtr ptr, AttributeMap attributes2) {
        super(attributes2);
        this.array = (Ptr[])ptr.getArray();
        this.offset = 0;
        this.length = this.array.length;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    protected StringVector cloneWithNewAttributes(AttributeMap attributes2) {
        return new NativeStringVector(this.array, this.offset, this.length, attributes2);
    }

    @Override
    public String getElementAsString(int index) {
        Ptr string = this.array[this.offset + index];
        if (string == null) {
            return null;
        }
        return Stdlib.nullTerminatedString(string);
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }
}

