/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Unevaluated;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class Jvmi {
    private Jvmi() {
    }

    @Builtin(value="import")
    public static SEXP importClass(@Current Context context, @Current Environment rho, @Unevaluated Symbol className) {
        Class<?> clazz;
        try {
            clazz = context.getSession().getClassLoader().loadClass(className.getPrintName());
        }
        catch (ClassNotFoundException e) {
            throw new EvalException("Cannot find class '%s'", className);
        }
        if (!context.getSession().getSecurityManager().allowNewInstance(clazz)) {
            throw new EvalException("Permission to create a new instance of class '%s' has been denied by the security manager", className);
        }
        ExternalPtr ptr = new ExternalPtr(clazz);
        try {
            rho.setVariable(context, Symbol.get(clazz.getSimpleName()), ptr);
        }
        catch (EvalException e) {
            throw new EvalException(e.getMessage(), new Object[0]);
        }
        context.setInvisibleFlag();
        return ptr;
    }

    public static void addURL(URL u) {
        URLClassLoader sysloader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t2) {
            throw new EvalException("can not addURL %s into classLoader", u);
        }
    }

    @Builtin(value="jload")
    public static void jloadClass(@Current Context context, @Current Environment rho, String fileName) {
        try {
            File file2 = new File(fileName);
            if (!file2.exists()) {
                throw new EvalException("The file %s is not found %s", fileName, file2.getAbsolutePath());
            }
            Jvmi.addURL(file2.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new EvalException("No legal protocol could be found in %s ", fileName);
        }
    }
}

