/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.pipeliner.fusion.node;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Optional;
import org.renjin.pipeliner.ComputeMethod;
import org.renjin.pipeliner.fusion.node.LoopNode;
import org.renjin.repackaged.asm.Label;
import org.renjin.repackaged.asm.MethodVisitor;
import org.renjin.repackaged.asm.Type;
import org.renjin.sexp.Vector;

public class UnaryVectorOpNode
extends LoopNode {
    private String operatorName;
    private LoopNode operand;
    private final Class<?> operandType;
    private Method applyMethod;
    private Class<?> returnType;

    public UnaryVectorOpNode(String name, Method operator, LoopNode operand) {
        this.operatorName = name;
        this.applyMethod = operator;
        assert (this.applyMethod != null);
        this.operandType = this.applyMethod.getParameterTypes()[0];
        this.operand = operand;
        this.returnType = this.applyMethod.getReturnType();
    }

    public static Method findMethod(Vector vector2) {
        for (Method method : vector2.getClass().getMethods()) {
            if (!method.getName().equals("compute") || !Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 1 || !UnaryVectorOpNode.supportedType(method.getReturnType()) || !UnaryVectorOpNode.supportedType(method.getParameterTypes()[0])) continue;
            return method;
        }
        return null;
    }

    @Override
    public void init(ComputeMethod method) {
        this.operand.init(method);
    }

    @Override
    public void pushLength(ComputeMethod method) {
        this.operand.pushLength(method);
    }

    @Override
    public boolean mustCheckForIntegerNAs() {
        return this.operand.mustCheckForIntegerNAs();
    }

    @Override
    public void appendToKey(StringBuilder key) {
        key.append(this.operatorName);
        key.append('(');
        this.operand.appendToKey(key);
        key.append(')');
    }

    private void pushResult(ComputeMethod method, Optional<Label> integerNaLabel) {
        if (this.operandType.equals(Double.TYPE)) {
            this.operand.pushElementAsDouble(method, integerNaLabel);
        } else if (this.operandType.equals(Integer.TYPE)) {
            this.operand.pushElementAsInt(method, integerNaLabel);
        } else {
            throw new UnsupportedOperationException("operandType: " + this.operandType);
        }
        MethodVisitor mv = method.getVisitor();
        mv.visitMethodInsn(184, Type.getInternalName(this.applyMethod.getDeclaringClass()), this.applyMethod.getName(), Type.getMethodDescriptor(this.applyMethod), false);
    }

    @Override
    public void pushElementAsDouble(ComputeMethod method, Optional<Label> integerNaLabel) {
        this.pushResult(method, integerNaLabel);
        this.cast(method.getVisitor(), this.returnType, Double.TYPE);
    }

    @Override
    public void pushElementAsInt(ComputeMethod method, Optional<Label> naLabel) {
        this.pushResult(method, naLabel);
        this.cast(method.getVisitor(), this.returnType, Integer.TYPE);
    }

    public String toString() {
        return this.operatorName + "(" + this.operand + ")";
    }
}

