/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.pipeliner.fusion.node;

import java.util.Optional;
import org.renjin.pipeliner.ComputeMethod;
import org.renjin.repackaged.asm.Label;
import org.renjin.repackaged.asm.MethodVisitor;
import org.renjin.repackaged.asm.Type;

public abstract class LoopNode {
    public abstract void init(ComputeMethod var1);

    public final void pushElementAsDouble(ComputeMethod method) {
        this.pushElementAsDouble(method, Optional.empty());
    }

    public abstract void pushElementAsDouble(ComputeMethod var1, Optional<Label> var2);

    public abstract void pushLength(ComputeMethod var1);

    protected final void pushIntConstant(MethodVisitor mv, int value) {
        if (value == 0) {
            mv.visitInsn(3);
        } else if (value == 1) {
            mv.visitInsn(4);
        } else if (value == 2) {
            mv.visitInsn(5);
        } else if (value == 3) {
            mv.visitInsn(6);
        } else if (value == 4) {
            mv.visitInsn(7);
        } else if (value == 5) {
            mv.visitInsn(8);
        } else if (value < 127) {
            mv.visitIntInsn(16, value);
        } else {
            mv.visitLdcInsn(value);
        }
    }

    protected final void cast(MethodVisitor mv, Type fromType, Type toType) {
        if (fromType.equals(toType)) {
            return;
        }
        if (fromType.getSort() == 5 && toType.getSort() == 8) {
            mv.visitInsn(135);
            return;
        }
        if (fromType.getSort() == 8 && toType.getSort() == 5) {
            mv.visitInsn(142);
            return;
        }
        throw new UnsupportedOperationException("Cast from " + fromType + " to " + toType);
    }

    protected final void cast(MethodVisitor mv, Class<?> fromType, Class<?> toType) {
        if (fromType.equals(toType)) {
            return;
        }
        if (fromType.equals(Integer.TYPE) && toType.equals(Double.TYPE)) {
            mv.visitInsn(135);
            return;
        }
        if (fromType.equals(Double.TYPE) && toType.equals(Integer.TYPE)) {
            mv.visitInsn(142);
            return;
        }
        throw new UnsupportedOperationException("Cast from " + fromType + " to " + toType);
    }

    protected static boolean supportedType(Class<?> type) {
        return type.equals(Double.TYPE) || type.equals(Integer.TYPE);
    }

    public final void pushElementAsInt(ComputeMethod method, int index) {
        MethodVisitor mv = method.getVisitor();
        this.pushIntConstant(mv, index);
        this.pushElementAsInt(method, Optional.empty());
    }

    public void pushElementAsInt(ComputeMethod method, Optional<Label> naLabel) {
        this.pushElementAsDouble(method);
        method.getVisitor().visitInsn(142);
    }

    protected final void doIntegerNaCheck(MethodVisitor mv, Optional<Label> naLabel) {
        if (naLabel.isPresent()) {
            mv.visitInsn(89);
            mv.visitFieldInsn(178, "org/renjin/sexp/IntVector", "NA", "I");
            mv.visitJumpInsn(159, naLabel.get());
        }
    }

    public abstract boolean mustCheckForIntegerNAs();

    public abstract void appendToKey(StringBuilder var1);
}

