/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.pipeliner.fusion.node;

import java.util.Optional;
import org.renjin.pipeliner.ComputeMethod;
import org.renjin.pipeliner.fusion.node.LoopNode;
import org.renjin.repackaged.asm.Label;
import org.renjin.repackaged.asm.MethodVisitor;
import org.renjin.repackaged.asm.Type;

public class IntArrayNode
extends LoopNode {
    protected int arrayLocalIndex;
    protected int operandIndex;
    private String vectorType;

    public IntArrayNode(int operandIndex, Type vectorType) {
        this.operandIndex = operandIndex;
        this.vectorType = vectorType.getInternalName();
    }

    @Override
    public void init(ComputeMethod method) {
        this.arrayLocalIndex = method.reserveLocal(1);
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(25, method.getOperandsLocalIndex());
        this.pushIntConstant(mv, this.operandIndex);
        mv.visitInsn(50);
        mv.visitTypeInsn(192, this.vectorType);
        mv.visitMethodInsn(182, this.vectorType, "toIntArrayUnsafe", "()[I", false);
        mv.visitVarInsn(58, this.arrayLocalIndex);
    }

    @Override
    public void pushLength(ComputeMethod method) {
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(25, this.arrayLocalIndex);
        mv.visitInsn(190);
    }

    @Override
    public void pushElementAsDouble(ComputeMethod method, Optional<Label> integerNaLabel) {
        this.pushElementAsInt(method, integerNaLabel);
        MethodVisitor mv = method.getVisitor();
        mv.visitInsn(135);
    }

    @Override
    public void pushElementAsInt(ComputeMethod method, Optional<Label> integerNaLabel) {
        MethodVisitor mv = method.getVisitor();
        mv.visitVarInsn(25, this.arrayLocalIndex);
        mv.visitInsn(95);
        mv.visitInsn(46);
        this.doIntegerNaCheck(mv, integerNaLabel);
    }

    @Override
    public boolean mustCheckForIntegerNAs() {
        return true;
    }

    @Override
    public void appendToKey(StringBuilder key) {
        key.append("IAN:" + this.vectorType);
    }

    public String toString() {
        return "x" + this.operandIndex;
    }
}

