/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.pipeliner;

import java.util.concurrent.ExecutorService;
import org.renjin.eval.Profiler;
import org.renjin.pipeliner.DeferredGraph;
import org.renjin.pipeliner.DeferredGraphEval;
import org.renjin.pipeliner.fusion.LoopKernelCache;
import org.renjin.primitives.ni.DeferredNativeCall;
import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.primitives.vector.MemoizedDoubleVector;
import org.renjin.repackaged.guava.util.concurrent.ListeningExecutorService;
import org.renjin.repackaged.guava.util.concurrent.MoreExecutors;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class VectorPipeliner {
    public static boolean DEBUG = "true".equals(System.getProperty("renjin.vp.debug"));
    public static int MAX_DEPTH = 25;
    private final ListeningExecutorService executorService;
    private final LoopKernelCache loopKernelCache;

    public VectorPipeliner(ExecutorService executorService) {
        this.executorService = MoreExecutors.listeningDecorator(executorService);
        this.loopKernelCache = new LoopKernelCache(executorService);
    }

    public void materialize(DeferredNativeCall call2) {
        DeferredGraph graph = new DeferredGraph(call2);
        graph.optimize(this.loopKernelCache);
        graph.dumpGraph();
        throw new UnsupportedOperationException("TODO");
    }

    public Vector materialize(Vector root) {
        DeferredGraph graph = new DeferredGraph(root);
        this.materializeGraph(graph);
        return graph.getRootResult(0);
    }

    public ListVector materialize(ListVector listVector) {
        DeferredGraph graph = new DeferredGraph();
        Vector[] vectors = new Vector[listVector.length()];
        for (int i = 0; i < listVector.length(); ++i) {
            Vector vector2;
            SEXP element = listVector.getElementAsSEXP(i);
            if (!(element instanceof Vector) || !((Vector)element).isDeferred()) continue;
            vectors[i] = vector2 = (Vector)element;
            graph.addRoot(vector2);
        }
        this.materializeGraph(graph);
        ListVector.Builder newList = new ListVector.Builder(0, listVector.length());
        newList.copyAttributesFrom(listVector);
        int vectorIndex = 0;
        for (int i = 0; i < listVector.length(); ++i) {
            if (vectors[i] == null) {
                newList.add(listVector.getElementAsSEXP(i));
                continue;
            }
            newList.add(graph.getRootResult(vectorIndex));
            ++vectorIndex;
        }
        return newList.build();
    }

    private void materializeGraph(DeferredGraph graph) {
        long start = System.nanoTime();
        if (DEBUG) {
            System.out.print("unopt");
            graph.dumpGraph();
        }
        graph.optimize(this.loopKernelCache);
        if (DEBUG) {
            graph.dumpGraph();
        }
        this.evaluate(graph);
        if (Profiler.ENABLED) {
            long time2 = System.nanoTime() - start;
            Profiler.materialized(time2);
        }
    }

    public Vector simplify(DeferredComputation root) {
        Vector vector2;
        DeferredGraph graph = new DeferredGraph(root);
        if (DEBUG) {
            System.err.println("simplify");
            graph.dumpGraph();
        }
        if ((vector2 = this.materialize(root)) instanceof MemoizedDoubleVector) {
            return vector2;
        }
        if (vector2.isDeferred() && vector2 instanceof DoubleVector) {
            return DoubleArrayVector.unsafe(((DoubleVector)vector2).toDoubleArray(), vector2.getAttributes());
        }
        return vector2;
    }

    public void evaluate(DeferredGraph graph) {
        DeferredGraphEval eval2 = new DeferredGraphEval(graph, this.executorService);
        eval2.execute();
    }
}

