/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.parser;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import org.renjin.parser.Position;
import org.renjin.parser.RLexException;

public class RLexerReader {
    private static final int PUSHBACK_BUFSIZE = 16;
    private int[] pushback = new int[16];
    private int npush = 0;
    private Reader reader;
    private int prevpos = 0;
    private int[] prevlines = new int[16];
    private int[] prevcols = new int[16];
    private int[] prevbytes = new int[16];
    private int lineNumber = 0;
    private int charIndex = -1;
    private int columnNumber = -1;

    public RLexerReader(Reader reader) {
        this.reader = new PushbackReader(reader);
    }

    public Position getPosition() {
        return new Position(this.lineNumber, this.columnNumber, this.charIndex);
    }

    public int read() throws IOException {
        int c2;
        if (this.npush != 0) {
            c2 = this.pushback[--this.npush];
        } else {
            try {
                c2 = this.reader.read();
            }
            catch (IOException e) {
                throw new RLexException("IOException while reading", e);
            }
        }
        this.prevpos = (this.prevpos + 1) % 16;
        this.prevcols[this.prevpos] = this.columnNumber++;
        this.prevlines[this.prevpos] = this.lineNumber++;
        this.prevbytes[this.prevpos] = this.charIndex++;
        if (c2 == 10) {
            this.columnNumber = -1;
            this.charIndex = -1;
        }
        if (c2 == 9) {
            this.columnNumber = this.columnNumber + 7 & 0xFFFFFFF8;
        }
        return c2;
    }

    public int unread(int c2) {
        this.lineNumber = this.prevlines[this.prevpos];
        this.columnNumber = this.prevcols[this.prevpos];
        this.charIndex = this.prevbytes[this.prevpos];
        this.prevpos = (this.prevpos + 16 - 1) % 16;
        if (this.npush >= 16) {
            throw new RuntimeException("Pusback buffer exceeded");
        }
        this.pushback[this.npush++] = c2;
        return c2;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getCharacterIndex() {
        return this.charIndex;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
        this.columnNumber = 0;
    }
}

