/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.parser;

public class Position {
    private int line;
    private int column;
    private int charIndex;

    public Position() {
    }

    public Position(int line, int column, int charIndex) {
        this.line = line;
        this.column = column;
        this.charIndex = charIndex;
    }

    public Position clone() {
        return new Position(this.getLine(), this.getColumn(), this.getCharIndex());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Position position = (Position)o;
        if (this.getCharIndex() != position.getCharIndex()) {
            return false;
        }
        if (this.getColumn() != position.getColumn()) {
            return false;
        }
        return this.getLine() == position.getLine();
    }

    public int hashCode() {
        int result = this.getLine();
        result = 31 * result + this.getColumn();
        result = 31 * result + this.getCharIndex();
        return result;
    }

    public String toString() {
        return "line " + (this.getLine() + 1) + " byte " + (this.getCharIndex() + 1) + " col " + (this.getColumn() + 1);
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getCharIndex() {
        return this.charIndex;
    }
}

