/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.pnbinom;
import org.renjin.nmath.qnorm;
import org.renjin.nmath.qpois;

public class qnbinom {
    private qnbinom() {
    }

    public static double do_search(double d, Ptr ptr, double d2, double d3, double d4, double d5) {
        block4: {
            if (ptr.getDouble() >= d2) {
                while (true) {
                    if (d == 0.0) break block4;
                    ptr.setDouble(pnbinom.pnbinom(d - d5, d3, d4, 1, 0));
                    if (ptr.getDouble() < d2) {
                        break block4;
                    }
                    d = fmax2.fmax2(0.0, d - d5);
                }
            }
            do {
                ptr.setDouble(pnbinom.pnbinom(d += d5, d3, d4, 1, 0));
            } while (!(ptr.getDouble() >= d2));
        }
        return d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qnbinom(double d, double d2, double d3, int n, int n2) {
        double d4;
        double[] dArray = new double[]{0.0};
        if (Builtins.__isnan(d) != 0) return d + d2 + d3;
        if (Builtins.__isnan(d2) != 0) return d + d2 + d3;
        if (Builtins.__isnan(d3) != 0) return d + d2 + d3;
        if (d3 == 0.0) {
            if (d2 == 0.0) return 0.0;
        }
        if (d3 <= 0.0) return Double.NaN;
        if (d3 > 1.0) return Double.NaN;
        if (d2 < 0.0) return Double.NaN;
        if (d3 == 1.0) return 0.0;
        if (d2 == 0.0) return 0.0;
        if (n2 != 0) {
            if (d > 0.0) return Double.NaN;
            if (d == 0.0) {
                if (n != 0) return Double.POSITIVE_INFINITY;
                return 0.0;
            }
            if (d == Double.NEGATIVE_INFINITY) {
                if (n == 0) return Double.POSITIVE_INFINITY;
                return 0.0;
            }
        } else {
            if (d < 0.0) return Double.NaN;
            if (d > 1.0) return Double.NaN;
            if (d == 0.0) {
                if (n == 0) return Double.POSITIVE_INFINITY;
                return 0.0;
            }
            if (d == 1.0) {
                if (n != 0) return Double.POSITIVE_INFINITY;
                return 0.0;
            }
        }
        double d5 = 1.0 / d3;
        double d6 = (1.0 - d3) * d5;
        double d7 = d2 * d6;
        double d8 = Mathlib.sqrt(d2 * d6 * d5);
        d5 = (d5 + d6) / d8;
        if (n == 0 || n2 != 0) {
            if (n2 != 0) {
                d = n != 0 ? Math.exp(d) : -Mathlib.expm1(d);
            } else if (n == 0) {
                d = 0.5 - d + 0.5;
            }
            d6 = n != 0 ? (n2 != 0 ? Double.NEGATIVE_INFINITY : 0.0) : (n2 != 0 ? 0.0 : 1.0);
            if (d6 == d) return 0.0;
            d6 = n != 0 ? (n2 != 0 ? 0.0 : 1.0) : (n2 != 0 ? Double.NEGATIVE_INFINITY : 0.0);
            if (d6 == d) return Double.POSITIVE_INFINITY;
        }
        if (d + 2.242650509742816E-16 >= 1.0) return Double.POSITIVE_INFINITY;
        dArray[0] = qnorm.qnorm5(d, 0.0, 1.0, 1, 0);
        d8 = Mathlib.round(((dArray[0] * dArray[0] - 1.0) * d5 / 6.0 + dArray[0]) * d8 + d7);
        dArray[0] = pnbinom.pnbinom(d8, d2, d3, 1, 0);
        d *= 0.9999999999999858;
        if (d8 < 100000.0) return qnbinom.do_search(d8, new DoublePtr(dArray, 0), d, d2, d3, 1.0);
        d7 = Mathlib.floor(d8 * 0.001);
        do {
            d4 = d7;
            d8 = qnbinom.do_search(d8, new DoublePtr(dArray, 0), d, d2, d3, d7);
            d7 = fmax2.fmax2(1.0, Mathlib.floor(d7 / 100.0));
        } while (d4 > 1.0 && d8 * 1.0E-15 < d7);
        return d8;
    }

    public static double qnbinom_mu(double d, double d2, double d3, int n, int n2) {
        d = d2 == Double.POSITIVE_INFINITY ? qpois.qpois(d, d3, n, n2) : qnbinom.qnbinom(d, d2, d2 / (d2 + d3), n, n2);
        return d;
    }
}

