/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.fmin2;
import org.renjin.nmath.pbinom;
import org.renjin.nmath.qnorm;

public class qbinom {
    private qbinom() {
    }

    public static double do_search(double d, Ptr ptr, double d2, double d3, double d4, double d5) {
        block4: {
            if (ptr.getDouble() >= d2) {
                while (true) {
                    double d6;
                    if (d == 0.0 || (d6 = pbinom.pbinom(d - d5, d3, d4, 1, 0)) < d2) {
                        break block4;
                    }
                    d = fmax2.fmax2(0.0, d - d5);
                    ptr.setDouble(d6);
                }
            }
            while ((d = fmin2.fmin2(d + d5, d3)) != d3) {
                ptr.setDouble(pbinom.pbinom(d, d3, d4, 1, 0));
                if (!(ptr.getDouble() >= d2)) continue;
            }
        }
        return d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qbinom(double d, double d2, double d3, int n, int n2) {
        double d4;
        double[] dArray = new double[]{0.0};
        if (Builtins.__isnan(d) != 0) return d + d2 + d3;
        if (Builtins.__isnan(d2) != 0) return d + d2 + d3;
        if (Builtins.__isnan(d3) != 0) return d + d2 + d3;
        if (Builtins.__finite(d2) == 0) return Double.NaN;
        if (Builtins.__finite(d3) == 0) return Double.NaN;
        if (Builtins.__finite(d) == 0) {
            if (n2 == 0) return Double.NaN;
        }
        if (Mathlib.floor(d2 + 0.5) != d2) return Double.NaN;
        if (d3 < 0.0) return Double.NaN;
        if (d3 > 1.0) return Double.NaN;
        if (d2 < 0.0) return Double.NaN;
        if (n2 != 0) {
            if (d > 0.0) return Double.NaN;
            if (d == 0.0) {
                if (n != 0) return d2;
                return 0.0;
            }
            if (d == Double.NEGATIVE_INFINITY) {
                if (n == 0) return d2;
                return 0.0;
            }
        } else {
            if (d < 0.0) return Double.NaN;
            if (d > 1.0) return Double.NaN;
            if (d == 0.0) {
                if (n == 0) return d2;
                return 0.0;
            }
            if (d == 1.0) {
                if (n != 0) return d2;
                return 0.0;
            }
        }
        if (d3 == 0.0) return 0.0;
        if (d2 == 0.0) return 0.0;
        double d5 = 1.0 - d3;
        if (d5 == 0.0) return d2;
        double d6 = d2 * d3;
        double d7 = Mathlib.sqrt(d2 * d3 * d5);
        d5 = (d5 - d3) / d7;
        if (n == 0 || n2 != 0) {
            double d8;
            if (n2 != 0) {
                d = n != 0 ? Math.exp(d) : -Mathlib.expm1(d);
                d8 = d;
            } else {
                if (n == 0) {
                    d = 0.5 - d + 0.5;
                }
                d8 = d;
            }
            d = d8;
            if (d8 == 0.0) return 0.0;
            if (d8 == 1.0) return d2;
        }
        if (d + 2.242650509742816E-16 >= 1.0) return d2;
        dArray[0] = qnorm.qnorm5(d, 0.0, 1.0, 1, 0);
        d7 = Mathlib.floor(((dArray[0] * dArray[0] - 1.0) * d5 / 6.0 + dArray[0]) * d7 + d6 + 0.5);
        if (d7 > d2) {
            d7 = d2;
        }
        dArray[0] = pbinom.pbinom(d7, d2, d3, 1, 0);
        d *= 0.9999999999999858;
        if (d2 < 100000.0) return qbinom.do_search(d7, new DoublePtr(dArray, 0), d, d2, d3, 1.0);
        d6 = Mathlib.floor(d2 * 0.001);
        do {
            d4 = d6;
            d7 = qbinom.do_search(d7, new DoublePtr(dArray, 0), d, d2, d3, d6);
            d6 = fmax2.fmax2(1.0, Mathlib.floor(d6 / 100.0));
        } while (d4 > 1.0 && d2 * 1.0E-15 < d6);
        return d7;
    }
}

