/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.dbinom;
import org.renjin.nmath.fmax2;

public class dgeom {
    private dgeom() {
    }

    public static double dgeom(double d, double d2, int n) {
        if (Builtins.__isnan(d) != 0 || Builtins.__isnan(d2) != 0) {
            d += d2;
        } else if (d2 <= 0.0 || d2 > 1.0) {
            d = Double.NaN;
        } else if (Math.abs(d - Mathlib.round(d)) > fmax2.fmax2(1.0, Math.abs(d)) * 1.0E-7) {
            Stdlib.printf(new BytePtr("non-integer x = %f\u0000".getBytes(), 0), d);
            d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
        } else if (d < 0.0 || Builtins.__finite(d) == 0 || d2 == 0.0) {
            d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
        } else {
            d = dbinom.dbinom_raw(0.0, Mathlib.round(d), d2, 1.0 - d2, n);
            d = n != 0 ? Math.log(d2) + d : d2 * d;
        }
        return d;
    }
}

