/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.nmath.dbinom;
import org.renjin.nmath.dgamma;

public class df {
    private df() {
    }

    public static double df(double d, double d2, double d3, int n) {
        if (Builtins.__isnan(d) != 0 || Builtins.__isnan(d2) != 0 || Builtins.__isnan(d3) != 0) {
            d = d + d2 + d3;
        } else if (d2 <= 0.0 || d3 <= 0.0) {
            d = Double.NaN;
        } else if (d < 0.0) {
            d = n != 0 ? Double.NEGATIVE_INFINITY : 0.0;
        } else if (d == 0.0) {
            d = d2 > 2.0 ? (n != 0 ? Double.NEGATIVE_INFINITY : 0.0) : (d2 == 2.0 ? (n != 0 ? 0.0 : 1.0) : Double.POSITIVE_INFINITY);
        } else if (Builtins.__finite(d2) == 0 && Builtins.__finite(d3) == 0) {
            d = d == 1.0 ? Double.POSITIVE_INFINITY : (n != 0 ? Double.NEGATIVE_INFINITY : 0.0);
        } else if (Builtins.__finite(d3) == 0) {
            d = dgamma.dgamma(d, d2 / 2.0, 2.0 / d2, n);
        } else if (d2 > 1.0E14) {
            d2 = dgamma.dgamma(1.0 / d, d3 / 2.0, 2.0 / d3, n);
            d = n != 0 ? d2 - Math.log(d) * 2.0 : d2 / (d * d);
        } else {
            double d4 = 1.0 / (d * d2 + d3);
            double d5 = d3 * d4;
            d4 *= d * d2;
            if (d2 >= 2.0) {
                d = d2 * d5 / 2.0;
                d2 = dbinom.dbinom_raw((d2 - 2.0) / 2.0, (d2 + d3 - 2.0) / 2.0, d4, d5, n);
            } else {
                d = d2 * d2 * d5 / (d4 * 2.0 * (d2 + d3));
                d2 = dbinom.dbinom_raw(d2 / 2.0, (d2 + d3) / 2.0, d4, d5, n);
            }
            d = n != 0 ? Math.log(d) + d2 : (d *= d2);
        }
        return d;
    }
}

