/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Ptr;

public class chebyshev {
    private chebyshev() {
    }

    public static double Rf_chebyshev_eval(double d, Ptr ptr, int n) {
        if (n <= 0 || n > 1000) {
            d = Double.NaN;
        } else if (d < -1.1 || d > 1.1) {
            d = Double.NaN;
        } else {
            d *= 2.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            int n2 = 1;
            while (n2 <= n) {
                d3 = d2;
                d2 = d4;
                d4 = d * d4 - d3 + ptr.getDouble((n - n2) * 8);
                ++n2;
            }
            d = (d4 - d3) * 0.5;
        }
        return d;
    }

    public static int Rf_chebyshev_init(Ptr ptr, int n, double d) {
        int n2;
        block4: {
            if (n <= 0) {
                n2 = 0;
            } else {
                double d2 = 0.0;
                int n3 = 0;
                int n4 = 1;
                while (n4 <= n) {
                    n3 = n - n4;
                    d2 = Math.abs(ptr.getDouble(n3 * 8)) + d2;
                    if (d2 > d) {
                        n2 = n3;
                        break block4;
                    }
                    ++n4;
                }
                n2 = n3;
            }
        }
        return n2;
    }
}

