/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.methods;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.renjin.eval.ClosureDispatcher;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.methods.MethodDispatch;
import org.renjin.methods.PrimitiveMethodTable;
import org.renjin.primitives.Types;
import org.renjin.primitives.packaging.Namespace;
import org.renjin.primitives.special.SubstituteFunction;
import org.renjin.repackaged.guava.base.Strings;
import org.renjin.s4.CallingArguments;
import org.renjin.s4.Generic;
import org.renjin.s4.RankedMethod;
import org.renjin.s4.S4;
import org.renjin.s4.S4Cache;
import org.renjin.s4.S4Class;
import org.renjin.s4.S4ClassCache;
import org.renjin.s4.S4MethodCache;
import org.renjin.s4.S4MethodTable;
import org.renjin.s4.Signature;
import org.renjin.sexp.Closure;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.PrimitiveFunction;
import org.renjin.sexp.S4Object;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SpecialFunction;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class Methods {
    public static SEXP R_initMethodDispatch(@Current Context context, SEXP environ) {
        context.getSession().getSingleton(MethodDispatch.class).init(environ == Null.INSTANCE ? context.getGlobalEnvironment() : (Environment)environ);
        return environ;
    }

    @Builtin(value=".isMethodsDispatchOn")
    public static boolean isMethodsDispatchOn(@Current MethodDispatch methodDispatch) {
        return methodDispatch.isEnabled();
    }

    @Builtin(value=".isMethodsDispatchOn")
    public static void setMethodsDispatchOn(@Current MethodDispatch methodDispatch, boolean enabled) {
        methodDispatch.setEnabled(enabled);
    }

    public static boolean R_set_method_dispatch(@Current Context context, LogicalVector onOff) {
        MethodDispatch methodContext = context.getSession().getSingleton(MethodDispatch.class);
        boolean oldValue = methodContext.isEnabled();
        if (onOff.getElementAsLogical(0) == Logical.TRUE) {
            methodContext.setEnabled(true);
        } else if (onOff.getElementAsLogical(0) == Logical.FALSE) {
            methodContext.setEnabled(false);
        }
        return oldValue;
    }

    public static S4Object Rf_allocS4Object() {
        return new S4Object();
    }

    public static ExternalPtr R_externalptr_prototype_object() {
        return new ExternalPtr<Object>(null);
    }

    public static SEXP R_set_slot(@Current Context context, SEXP object2, String name, SEXP value) {
        if (name.equals(".Data")) {
            return context.evaluate(FunctionCall.newCall(Symbol.get("setDataPart"), object2, value), context.getSingleton(MethodDispatch.class).getMethodsNamespace());
        }
        SEXP slotValue = value == Null.INSTANCE ? Symbols.S4_NULL : value;
        return object2.setAttributes(object2.getAttributes().copyS4().set(name, slotValue));
    }

    public static SEXP R_get_slot(@Current Context context, SEXP object2, String what) {
        return Methods.R_do_slot(context, object2, StringArrayVector.valueOf(what));
    }

    public static int R_has_slot(SEXP obj, SEXP name) {
        Symbol slot = Symbol.get(name.asString());
        Map<Symbol, SEXP> objSlots = obj.getAttributes().toMap();
        if (objSlots.containsKey(slot)) {
            return 1;
        }
        return 0;
    }

    public static String R_methodsPackageMetaName(String prefix, String name, String packageName) {
        StringBuilder metaName = new StringBuilder().append(".__").append(prefix).append("__").append(name);
        if (!Strings.isNullOrEmpty(packageName)) {
            metaName.append(":").append(packageName);
        }
        return metaName.toString();
    }

    public static SEXP R_getClassFromCache(@Current Context context, SEXP className, Environment table) {
        if (className instanceof StringVector) {
            String packageName = className.getAttributes().getPackage();
            SEXP cachedValue = table.getVariable(context, Symbol.get(((StringVector)className).getElementAsString(0)));
            if (cachedValue == Symbol.UNBOUND_VALUE) {
                return Null.INSTANCE;
            }
            String cachedPackage = cachedValue.getAttributes().getPackage();
            if (packageName == null || cachedPackage == null || packageName.equals(cachedPackage)) {
                return cachedValue;
            }
            return Null.INSTANCE;
        }
        if (!(className instanceof S4Object)) {
            throw new EvalException("Class should be either a character-string name or a class definition", new Object[0]);
        }
        return className;
    }

    public static boolean R_identC(SEXP e1, SEXP e2) {
        if (e1 instanceof StringVector && e2 instanceof StringVector && e1.length() == 1 && e2.length() == 1) {
            StringVector s1 = (StringVector)e1;
            StringVector s2 = (StringVector)e2;
            if (!s1.isElementNA(0)) {
                return s1.getElementAsString(0).equals(s2.getElementAsString(0));
            }
        }
        return false;
    }

    public static SEXP R_do_new_object(S4Object classRepresentation) {
        SEXP classNameExp = classRepresentation.getAttributes().get(Symbols.CLASS_NAME);
        String className = ((StringVector)classNameExp).getElementAsString(0);
        SEXP prototype = classRepresentation.getAttribute(Symbols.PROTOTYPE);
        if (prototype instanceof S4Object || classNameExp.getAttributes().getPackage() != null) {
            return prototype.setAttribute(Symbols.CLASS, classNameExp);
        }
        return prototype;
    }

    @Builtin(value=".cache_class")
    public static SEXP cacheClass(@Current Context context, String className) {
        return context.getSession().getSingleton(MethodDispatch.class).getExtends(className);
    }

    @Builtin(value=".cache_class")
    public static SEXP cacheClass(@Current Context context, String className, SEXP klass) {
        context.getSession().getSingleton(MethodDispatch.class).putExtends(className, klass);
        return klass;
    }

    public static SEXP R_getGeneric(@Current Context context, String symbol2, boolean mustFind, Environment rho, String pkg) {
        return Methods.R_getGeneric(context, Symbol.get(symbol2), mustFind, rho, pkg);
    }

    public static SEXP R_getGeneric(@Current Context context, Symbol symbol2, boolean mustFind, Environment rho, String pkg) {
        SEXP generic = Methods.getGeneric(context, symbol2, rho, pkg);
        if (generic == Symbol.UNBOUND_VALUE) {
            if (mustFind) {
                throw new EvalException("No generic function definition found for '%s' in the supplied environment", symbol2.getPrintName());
            }
            generic = Null.INSTANCE;
        }
        return generic;
    }

    protected static SEXP getGeneric(@Current Context context, Symbol symbol2, Environment env2, String pkg) {
        String gpackage;
        SEXP vl;
        SEXP generic = Symbol.UNBOUND_VALUE;
        for (Environment rho = env2; rho != Environment.EMPTY; rho = rho.getParent()) {
            vl = rho.getVariable(context, symbol2);
            if (vl == Symbol.UNBOUND_VALUE) continue;
            vl = vl.force(context);
            boolean ok = false;
            if (Methods.IS_GENERIC(vl)) {
                if (!Strings.isNullOrEmpty(pkg)) {
                    gpackage = vl.getAttributes().getPackage();
                    ok = pkg.equals(gpackage);
                } else {
                    ok = true;
                }
            }
            if (ok) {
                generic = vl;
                break;
            }
            vl = Symbol.UNBOUND_VALUE;
        }
        if (generic == Symbol.UNBOUND_VALUE && Methods.IS_GENERIC(vl = context.getBaseEnvironment().getVariable(context, symbol2))) {
            generic = vl;
            if (vl.getAttributes().getPackage() != null && !(gpackage = vl.getAttributes().getPackage()).equals(pkg)) {
                generic = Symbol.UNBOUND_VALUE;
            }
        }
        return generic;
    }

    private static boolean IS_GENERIC(SEXP value) {
        return value instanceof Closure && value.getAttributes().has(Symbols.GENERIC);
    }

    public static SEXP do_substitute_direct(@Current Context context, SEXP f, SEXP env2) {
        return SubstituteFunction.substitute(context, f, env2);
    }

    public static SEXP R_M_setPrimitiveMethods(@Current Context context, SEXP fname, SEXP op, String code_vec, SEXP fundef, SEXP mlist) {
        return Methods.R_set_prim_method(context, fname, op, code_vec, fundef, mlist);
    }

    public static void do_set_prim_method(@Current Context context, PrimitiveFunction op, String code_string, SEXP fundef, SEXP mlist) {
        PrimitiveMethodTable.prim_methods_t code = Methods.parseCode(code_string);
        PrimitiveMethodTable table = context.getSession().getSingleton(PrimitiveMethodTable.class);
        PrimitiveMethodTable.Entry entry = table.get(op);
        entry.setMethods(code);
        if (code != PrimitiveMethodTable.prim_methods_t.SUPPRESSED && fundef != Null.INSTANCE) {
            entry.setGeneric((Closure)fundef);
        }
        if (code == PrimitiveMethodTable.prim_methods_t.HAS_METHODS) {
            entry.setMethodList(mlist);
        }
    }

    public static SEXP R_set_prim_method(@Current Context context, SEXP fname, SEXP op, String code_string, SEXP fundef, SEXP mlist) {
        PrimitiveMethodTable table = context.getSession().getSingleton(PrimitiveMethodTable.class);
        if (op == Null.INSTANCE) {
            SEXP value = LogicalVector.valueOf(table.isPrimitiveMethodsAllowed());
            switch (Methods.parseCode(code_string)) {
                case NO_METHODS: {
                    table.setPrimitiveMethodsAllowed(false);
                    break;
                }
                case HAS_METHODS: {
                    table.setPrimitiveMethodsAllowed(true);
                    break;
                }
            }
            return value;
        }
        Methods.do_set_prim_method(context, (PrimitiveFunction)op, code_string, fundef, mlist);
        return fname;
    }

    private static PrimitiveMethodTable.prim_methods_t parseCode(String code_string) {
        PrimitiveMethodTable.prim_methods_t code = PrimitiveMethodTable.prim_methods_t.NO_METHODS;
        if (code_string.equalsIgnoreCase("clear")) {
            code = PrimitiveMethodTable.prim_methods_t.NO_METHODS;
        } else if (code_string.equalsIgnoreCase("reset")) {
            code = PrimitiveMethodTable.prim_methods_t.NEEDS_RESET;
        } else if (code_string.equalsIgnoreCase("set")) {
            code = PrimitiveMethodTable.prim_methods_t.HAS_METHODS;
        } else if (code_string.equalsIgnoreCase("suppress")) {
            code = PrimitiveMethodTable.prim_methods_t.SUPPRESSED;
        } else {
            throw new EvalException("invalid primitive methods code (\"%s\"): should be \"clear\", \"reset\", \"set\", or \"suppress\"", code_string);
        }
        return code;
    }

    @Internal
    public static SEXP getClass(@Current Context context, SEXP className, boolean dotForce, SEXP where) {
        if (className instanceof S4Object) {
            return className;
        }
        SEXP classDef = Methods.getClassDef(context, (StringVector)className, Null.INSTANCE, Null.INSTANCE, true);
        if (dotForce && (classDef == Null.INSTANCE || classDef == Symbol.UNBOUND_VALUE)) {
            if (dotForce) {
                System.out.println("getClass(" + ((StringVector)className).getElementAsString(0) + ", .Force = TRUE)");
                SEXP env2 = where == Null.INSTANCE ? context.getCallingEnvironment() : where;
                PairList.Builder args2 = new PairList.Builder();
                args2.add(className);
                args2.add(Symbol.get("package"), (SEXP)StringVector.valueOf("base"));
                args2.add(Symbol.get("virtual"), (SEXP)LogicalVector.TRUE);
                args2.add(Symbol.get("where"), env2);
                classDef = context.evaluate(FunctionCall.newCall(Symbol.get("makeClassRepresentation"), args2.build()));
            } else {
                throw new EvalException("'" + ((StringVector)className).getElementAsString(0) + "' is not a defined class", new Object[0]);
            }
        }
        return classDef;
    }

    @Internal
    public static SEXP getClassDef(@Current Context context, StringVector className, SEXP where, SEXP packageName, boolean inherits2) {
        S4Cache s4Cache;
        S4Class s4Class;
        SEXP classDef = Symbol.UNBOUND_VALUE;
        String providedPackage = null;
        if (inherits2 && (s4Class = (s4Cache = context.getSession().getS4Cache()).getS4ClassCache().lookupClass(context, className.getElementAsString(0))) != null) {
            classDef = s4Class.getDefinition();
        }
        if (classDef == Symbol.UNBOUND_VALUE) {
            Symbol metadataName = Symbol.get(".__C__" + className);
            if (packageName == Null.INSTANCE) {
                SEXP packageSlot = className.getAttribute(Symbols.PACKAGE);
                if (packageSlot != Null.INSTANCE) {
                    providedPackage = ((StringArrayVector)packageSlot).getElementAsString(0);
                }
            } else if (packageName instanceof StringArrayVector) {
                providedPackage = ((StringArrayVector)packageName).getElementAsString(0);
            }
            if (!Strings.isNullOrEmpty(providedPackage)) {
                Optional<Namespace> namespace = context.getNamespaceRegistry().getNamespaceIfPresent(Symbol.get(providedPackage));
                if (!namespace.isPresent()) {
                    throw new EvalException("Package " + providedPackage + " is not loaded", new Object[0]);
                }
                classDef = namespace.get().getNamespaceEnvironment().findVariable(context, metadataName, x -> true, inherits2);
            } else {
                if (where == Null.INSTANCE) {
                    SEXP parentFrame = context.evaluate(FunctionCall.newCall(Symbol.get("parent.frame"), IntVector.valueOf(1)));
                    where = context.evaluate(FunctionCall.newCall(Symbol.get("topenv"), parentFrame));
                }
                classDef = ((Environment)where).findVariable(context, metadataName, x -> true, inherits2);
            }
        }
        if (classDef == Symbol.UNBOUND_VALUE) {
            return Null.INSTANCE;
        }
        if (!Types.isS4(classDef = classDef.force(context))) {
            throw new EvalException("ClassDefinition " + className + " is corrupted. Please rebuild package: " + classDef.getAttribute(Symbol.get("package")), new Object[0]);
        }
        return classDef;
    }

    @Internal
    public static SEXP selectMethod(@Current Context context, SEXP functionName, StringArrayVector args2, LogicalArrayVector opt, LogicalArrayVector useInherited, SEXP mlist, SEXP fdef, SEXP verbose, SEXP doCache) {
        boolean[] inheritance;
        String fname;
        boolean optional = opt.isElementTrue(0);
        if (functionName instanceof StringVector) {
            fname = ((StringVector)functionName).getElementAsString(0);
        } else if (functionName instanceof SpecialFunction) {
            fname = ((SpecialFunction)functionName).getName();
        } else if (functionName instanceof Closure) {
            fname = ((StringArrayVector)functionName.getAttribute(Symbols.GENERIC)).getElementAsString(0);
        } else {
            throw new EvalException("type of f is invalid, should be string, generic function, or primitive", new Object[0]);
        }
        String packageName = Methods.getPackageName(context, fdef);
        Generic generic = Generic.standardGeneric(context, fname, packageName);
        S4MethodCache methodCache = context.getSession().getS4Cache().getS4MethodCache();
        S4MethodTable methodTable = methodCache.getMethod(context, generic, fname);
        if (methodTable == null || methodTable.isEmpty()) {
            if (optional) {
                return Null.INSTANCE;
            }
            throw new EvalException("selectMethod(" + fname + "): No methods found!", new Object[0]);
        }
        Signature signature = new Signature(args2.toArray());
        RankedMethod selectedMethod = methodTable.selectMethod(context, generic, signature, inheritance = Methods.computeUseInheritance(args2, useInherited, generic, methodTable));
        if (selectedMethod == null) {
            if (optional) {
                return Null.INSTANCE;
            }
            throw new EvalException("selectMethod(" + fname + "): No matching methods found! 'optional' is set to FALSE.", new Object[0]);
        }
        return selectedMethod.getMethodDefinition();
    }

    public static boolean[] computeUseInheritance(StringArrayVector args2, LogicalArrayVector useInherited, Generic generic, S4MethodTable methodTable) {
        boolean[] inheritance = new boolean[methodTable.getMaximumSignatureLength()];
        int useInheritedLength = useInherited.length();
        if (useInheritedLength == 1) {
            Arrays.fill(inheritance, useInherited.isElementTrue(0));
        } else {
            int j = 0;
            int i = 0;
            while (i < args2.length()) {
                if (j == useInheritedLength) {
                    j = 0;
                }
                inheritance[i] = useInherited.isElementTrue(j) && !"ANY".equals(args2.getElementAsString(i));
                ++i;
                ++j;
            }
        }
        if ("coerce".equals(generic.getName())) {
            inheritance = new boolean[]{inheritance[0], false};
        }
        return inheritance;
    }

    public static String getPackageName(@Current Context context, SEXP fdef) {
        String packageName = fdef instanceof Closure ? fdef.getAttribute(S4.PACKAGE).asString() : context.getFunction().getAttribute(S4.PACKAGE).asString();
        return packageName;
    }

    @Builtin
    public static SEXP standardGeneric(@Current Context context, Symbol fname, SEXP fdef) {
        return Methods.standardGeneric(context, Environment.EMPTY, fname.getPrintName());
    }

    @Builtin
    public static SEXP standardGeneric(@Current Context context, @Current Environment ev, String fname) {
        if (Strings.isNullOrEmpty(fname)) {
            throw new EvalException("argument to 'standardGeneric' must be a non-empty character string", new Object[0]);
        }
        String packageName = context.getFunction().getAttribute(S4.PACKAGE).asString();
        Generic generic = Generic.standardGeneric(context, fname, packageName);
        S4MethodCache methodCache = context.getSession().getS4Cache().getS4MethodCache();
        S4MethodTable methodTable = methodCache.getMethod(context, generic, fname);
        if (methodTable == null || methodTable.isEmpty()) {
            throw new EvalException("standardGeneric(" + fname + "): No methods found!", new Object[0]);
        }
        CallingArguments arguments = CallingArguments.standardGenericArguments(context, methodTable.getArgumentMatcher());
        Signature signature = arguments.getSignature(methodTable.getMaximumSignatureLength(), generic.getSignatureArgumentNames());
        boolean[] useInheritance = new boolean[methodTable.getMaximumSignatureLength()];
        Arrays.fill(useInheritance, Boolean.TRUE);
        RankedMethod selectedMethod = methodTable.selectMethod(context, generic, signature, useInheritance);
        if (selectedMethod == null) {
            throw new EvalException("unable to find an inherited method for function '" + fname + "' for signature " + arguments.getFullSignatureString(methodTable.getMaximumSignatureLength()), new Object[0]);
        }
        Closure function2 = selectedMethod.getMethodDefinition();
        Map<Symbol, SEXP> metadata = S4.generateCallMetaData(context, selectedMethod, signature, fname);
        PairList coercedArgs = Methods.coerce(context, arguments, selectedMethod);
        FunctionCall call2 = new FunctionCall(function2, context.getCall().getArguments());
        return ClosureDispatcher.apply(context, context.getCallingEnvironment(), call2, function2, coercedArgs, metadata);
    }

    public static PairList coerce(Context context, CallingArguments arguments, RankedMethod method) {
        int signatureLength = method.getMethodSignatureLength();
        Set<String> argNames = method.getMethod().getGeneric().getSignatureArgumentNames();
        S4ClassCache classCache = context.getSession().getS4Cache().getS4ClassCache();
        PairList.Builder coercedArgs = new PairList.Builder();
        int step = 0;
        for (PairList.Node arg : arguments.getPromisedArgs().nodes()) {
            SEXP value = arg.getValue();
            SEXP tag = arg.getRawTag();
            if (step < signatureLength && tag != Null.INSTANCE && argNames.contains(arg.getTag().getPrintName())) {
                String from = arguments.getArgumentClass(step);
                String to = method.getArgumentClass(step);
                if (to.equals(from) || to.equals("ANY") || classCache.isSimple(from, to)) {
                    coercedArgs.add(tag, value);
                } else {
                    SEXP coercedArg = classCache.coerceComplex(context, value, from, to);
                    coercedArgs.add(tag, coercedArg);
                }
                ++step;
                continue;
            }
            coercedArgs.add(tag, value);
        }
        return coercedArgs.build();
    }

    public static SEXP get_this_generic(Context context, String fname) {
        SEXP value = Null.INSTANCE;
        Context cptr = context;
        while (!cptr.isTopLevel()) {
            SEXP generic;
            SEXP function2 = cptr.getFunction();
            if (function2.isObject() && (generic = function2.getAttribute(MethodDispatch.GENERIC)) instanceof StringVector && generic.asString().equals(fname)) {
                value = function2;
                break;
            }
            cptr = cptr.getParent();
        }
        return value;
    }

    private static Symbol checkSlotName(SEXP name) {
        if (name instanceof Symbol) {
            return (Symbol)name;
        }
        if (name instanceof StringVector && name.length() == 1) {
            return Symbol.get(name.asString());
        }
        throw new EvalException("Invalid type or length for a slot name", new Object[0]);
    }

    static SEXP R_do_slot(Context context, SEXP obj, SEXP slotName) {
        Symbol name = Methods.checkSlotName(slotName);
        if (name == MethodDispatch.s_dot_Data) {
            return Methods.data_part(context, obj);
        }
        SEXP value = obj.getAttribute(name);
        if (value == Null.INSTANCE) {
            String input = name.getPrintName();
            if (name == MethodDispatch.s_dot_S3Class) {
                throw new UnsupportedOperationException();
            }
            input = name.getPrintName();
            SEXP classString = obj.getAttribute(Symbols.CLASS);
            if (classString == Null.INSTANCE) {
                throw new EvalException("cannot get a slot (\"%s\") from an object of type \"%s\"", input, obj.getTypeName());
            }
            throw new EvalException("no slot of name \"%s\" for this object of class \"%s\"", input, classString.asString());
        }
        if (value == MethodDispatch.pseudo_NULL) {
            value = Null.INSTANCE;
        }
        return value;
    }

    public static SEXP data_part(Context context, SEXP obj) {
        SEXP val = context.evaluate(FunctionCall.newCall(MethodDispatch.s_getDataPart, obj), context.getSession().getSingleton(MethodDispatch.class).getMethodsNamespace());
        return Types.setS4Object(val, false, false);
    }

    public static StringVector R_data_class(SEXP obj, boolean singleString) {
        SEXP klass = obj.getAttribute(Symbols.CLASS);
        int n = klass.length();
        if (n == 1 || n > 0 && !singleString) {
            return (StringVector)klass;
        }
        if (n == 0) {
            SEXP dim2 = obj.getAttribute(Symbols.DIM);
            int nd = dim2.length();
            if (nd > 0) {
                if (nd == 2) {
                    return StringVector.valueOf("matrix");
                }
                return StringVector.valueOf("array");
            }
            if (obj instanceof Function) {
                return StringVector.valueOf("function");
            }
            if (obj instanceof DoubleVector) {
                return StringVector.valueOf("numeric");
            }
            if (obj instanceof Symbol) {
                return StringVector.valueOf("name");
            }
        }
        return StringVector.valueOf(obj.getImplicitClass());
    }

    private static SEXP dispatchNonGeneric(Context context, String name, Environment env2, SEXP fdef) {
        SEXP fun;
        Symbol symbol2 = Symbol.get(name);
        for (Environment rho = env2.getParent(); rho != Environment.EMPTY && (!((fun = rho.getVariable(context, symbol2)) instanceof Closure) || Methods.isGenericFunction(context, fun)); rho = rho.getParent()) {
            fun = Symbol.UNBOUND_VALUE;
        }
        fun = symbol2;
        if (fun == Symbol.UNBOUND_VALUE) {
            throw new EvalException("unable to find a non-generic version of function \"%s\"", name);
        }
        Context cptr = context;
        while (!(cptr.isTopLevel() || cptr.getType() == Context.Type.FUNCTION && cptr.getEnvironment() == env2)) {
            cptr = cptr.getParent();
        }
        return context.evaluate(FunctionCall.newCall(fun, cptr.getArguments(), cptr.getCallingEnvironment()));
    }

    private static boolean isGenericFunction(@Current Context context, SEXP fun) {
        SEXP value = ((Closure)fun).getEnclosingEnvironment().getVariable(context, MethodDispatch.DOT_GENERIC);
        return value != Symbol.UNBOUND_VALUE;
    }

    public static String R_get_primname(PrimitiveFunction function2) {
        return function2.getName();
    }

    public static SEXP R_nextMethod(@Current Context context, FunctionCall matched_call, Environment ev) {
        int nargs2 = matched_call.length() - 1;
        SEXP op = ev.findVariable(context, MethodDispatch.R_dot_nextMethod);
        if (op == Symbol.UNBOUND_VALUE) {
            throw new EvalException("internal error in 'callNextMethod': '.nextMethod' was not assigned in the frame of the method call", new Object[0]);
        }
        PairList.Node e = (PairList.Node)matched_call.newCopyBuilder().build();
        boolean prim_case = op instanceof PrimitiveFunction;
        if (prim_case) {
            throw new UnsupportedOperationException();
        }
        e.setValue(MethodDispatch.R_dot_nextMethod);
        PairList args2 = e.getNext();
        for (int i = 0; i < nargs2; ++i) {
            PairList.Node argsNode = (PairList.Node)args2;
            SEXP this_sym = args2.getRawTag();
            if (argsNode.getValue() != Symbol.MISSING_ARG) {
                argsNode.setValue(this_sym);
            }
            args2 = argsNode.getNext();
        }
        if (prim_case) {
            throw new UnsupportedOperationException("todo: do_set_prim_method");
        }
        SEXP val = context.evaluate(e, ev);
        return val;
    }
}

