/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection.converters;

import org.renjin.invoke.reflection.converters.Converter;
import org.renjin.invoke.reflection.converters.PrimitiveScalarConverter;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class DoubleConverter
extends PrimitiveScalarConverter<Number> {
    public static final Converter INSTANCE = new DoubleConverter();

    private DoubleConverter() {
    }

    @Override
    public SEXP convertToR(Number value) {
        if (value == null) {
            return new DoubleArrayVector(DoubleVector.NA);
        }
        return new DoubleArrayVector(value.doubleValue());
    }

    public static boolean accept(Class clazz) {
        return clazz == Double.TYPE || clazz == Double.class || clazz == Float.TYPE || clazz == Float.class || clazz == Long.TYPE || clazz == Long.class;
    }

    @Override
    public Vector.Type getVectorType() {
        return DoubleVector.VECTOR_TYPE;
    }

    @Override
    protected Object getFirstElement(Vector value) {
        return value.getElementAsDouble(0);
    }

    @Override
    public boolean acceptsSEXP(SEXP exp2) {
        return exp2 instanceof DoubleVector || exp2 instanceof IntVector || exp2 instanceof LogicalVector;
    }

    @Override
    public int getSpecificity() {
        return 3;
    }
}

