/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.grDevices;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import org.renjin.eval.Session;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.grDevices.AwtContainer;
import org.renjin.grDevices.GraphicsDevice;
import org.renjin.grDevices.LocatorSync;
import org.renjin.sexp.ListVector;

public class AwtDevice
extends GraphicsDevice
implements WindowListener {
    private Frame frame;
    private final LocatorSync locator = new LocatorSync();

    public AwtDevice(Session session, ListVector options2) {
    }

    @Override
    public void open(double w, double h) {
        if (this.frame != null) {
            this.close();
        }
        AwtContainer awtContainer = new AwtContainer((int)w, (int)h);
        awtContainer.getPanel().addMouseListener(this.locator);
        this.container = awtContainer;
        this.frame = new Frame("Renjin");
        this.frame.setSize(new Dimension((int)w, (int)h));
        this.frame.setResizable(false);
        this.frame.add(awtContainer.getPanel());
        this.frame.setVisible(true);
        this.frame.addWindowListener(this);
    }

    @Override
    public void activate() {
        super.activate();
        if (this.frame != null) {
            this.frame.requestFocus();
            this.frame.setTitle("Renjin " + (this.deviceNumber > 0 ? "(" + (this.deviceNumber + 1) + ")" : "") + " *active*");
        }
    }

    @Override
    public void close() {
        super.close();
        if (this.frame != null) {
            this.container = null;
            this.frame.removeAll();
            this.frame.dispose();
            this.frame = null;
        }
    }

    @Override
    public void deactivate() {
        super.deactivate();
        if (this.frame != null) {
            this.frame.setTitle("Renjin " + (this.deviceNumber > 0 ? "(" + (this.deviceNumber + 1) + ")" : ""));
        }
    }

    @Override
    public void newPage(int deviceNumber) {
        super.newPage(deviceNumber);
        if (this.frame != null) {
            this.frame.setTitle("Renjin (" + (deviceNumber + 1) + ")" + (this.isActive() ? " *active*" : ""));
        }
    }

    @Override
    public Ptr locator() {
        return this.locator.waitForClick().map(p -> new DoublePtr(p.getX(), p.getX())).orElse(DoublePtr.NULL);
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

