/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gnur.api;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.renjin.gcc.runtime.AbstractFileHandle;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.FileHandle;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.RecordUnitPtr;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.primitives.Native;

public class RenjinFiles {
    public static Ptr fopen(Ptr filename, Ptr mode) {
        FileObject fileObject;
        String filenameString = Stdlib.nullTerminatedString(filename);
        String modeString = Stdlib.nullTerminatedString(mode);
        try {
            fileObject = Native.currentContext().resolveFile(filenameString);
        }
        catch (FileSystemException e) {
            return BytePtr.NULL;
        }
        try {
            return new RecordUnitPtr<FileHandle>(RenjinFiles.fopen(fileObject, modeString));
        }
        catch (IOException e) {
            return BytePtr.NULL;
        }
    }

    private static FileHandle fopen(FileObject fileObject, String mode) throws FileSystemException {
        switch (mode) {
            case "r": 
            case "rb": {
                return new InputStreamHandle(fileObject.getContent());
            }
            case "w": 
            case "wb": {
                return new OutputStreamHandle(fileObject.getContent().getOutputStream());
            }
        }
        throw new UnsupportedOperationException("mode: " + mode);
    }

    private static class OutputStreamHandle
    extends AbstractFileHandle {
        private OutputStream outputStream;

        public OutputStreamHandle(OutputStream outputStream) {
            this.outputStream = outputStream;
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException("Cannot read from output stream handle.");
        }

        @Override
        public void write(int b) throws IOException {
            this.outputStream.write(b);
        }

        @Override
        public void rewind() throws IOException {
            throw new UnsupportedOperationException("TODO");
        }

        @Override
        public void flush() throws IOException {
            this.outputStream.flush();
        }

        @Override
        public void close() throws IOException {
            this.outputStream.close();
        }

        @Override
        public void seekSet(long offset) throws IOException {
            throw new UnsupportedOperationException("TODO");
        }

        @Override
        public void seekCurrent(long offset) throws IOException {
            throw new UnsupportedOperationException("TODO");
        }

        @Override
        public void seekEnd(long offset) {
            throw new UnsupportedOperationException("TODO");
        }
    }

    private static class InputStreamHandle
    extends AbstractFileHandle {
        private FileContent content;
        private InputStream inputStream;
        private long position = 0L;

        public InputStreamHandle(FileContent content) throws FileSystemException {
            this.content = content;
            this.inputStream = content.getInputStream();
        }

        @Override
        public int read() throws IOException {
            int b = this.inputStream.read();
            if (b != -1) {
                ++this.position;
            }
            return b;
        }

        @Override
        public void write(int b) throws IOException {
            throw new UnsupportedOperationException("Cannot write on input stream handle.");
        }

        @Override
        public void rewind() throws IOException {
            this.inputStream.close();
            this.inputStream = this.content.getInputStream();
            this.position = 0L;
        }

        @Override
        public void flush() throws IOException {
            throw new UnsupportedOperationException("Cannot flush an input stream handle.");
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }

        @Override
        public void seekSet(long offset) throws IOException {
            if (offset < this.position) {
                throw new IOException("Cannot rewind the stream");
            }
            long toSkip = offset - this.position;
            long skipped = this.inputStream.skip(toSkip);
            if (skipped < toSkip) {
                throw new EOFException();
            }
        }

        @Override
        public void seekCurrent(long offset) throws IOException {
            long skipped = this.inputStream.skip(offset);
            if (skipped < offset) {
                throw new EOFException();
            }
        }

        @Override
        public void seekEnd(long offset) {
            throw new UnsupportedOperationException("TODO");
        }
    }
}

