/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gnur.api;

import java.util.Arrays;
import org.renjin.gnur.api.GnuCharSexp;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.StringVector;

public class GnuStringVector
extends StringVector {
    private GnuCharSexp[] values;

    public GnuStringVector(String string) {
        this(GnuCharSexp.valueOf(string));
    }

    public GnuStringVector(GnuCharSexp ... values) {
        this(values, AttributeMap.EMPTY);
    }

    public GnuStringVector(GnuCharSexp[] values, AttributeMap attributes2) {
        super(attributes2);
        this.values = values;
    }

    public static GnuStringVector copyOf(StringVector vector2) {
        if (vector2 instanceof GnuStringVector) {
            return new GnuStringVector(Arrays.copyOf(((GnuStringVector)vector2).values, vector2.length()));
        }
        GnuCharSexp[] values = new GnuCharSexp[vector2.length()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = GnuCharSexp.valueOf(vector2.getElementAsString(i));
        }
        return new GnuStringVector(values);
    }

    @Override
    public int length() {
        return this.values.length;
    }

    @Override
    protected StringVector cloneWithNewAttributes(AttributeMap attributes2) {
        return new GnuStringVector(this.values, attributes2);
    }

    @Override
    public String getElementAsString(int index) {
        GnuCharSexp value = this.values[index];
        if (value == GnuCharSexp.NA_STRING) {
            return null;
        }
        return value.getValue().nullTerminatedString();
    }

    @Override
    public boolean isElementNA(int index) {
        return this.values[index] == null;
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    public void set(int index, GnuCharSexp charValue) {
        this.values[index] = charValue;
    }

    public GnuCharSexp getElementAsCharSexp(int index) {
        return this.values[index];
    }
}

