/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.util.Arrays;
import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.MallocThunk;
import org.renjin.gcc.runtime.OffsetPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Realloc;

public class IntPtr
extends AbstractPtr
implements Ptr {
    public static final int BYTES = 4;
    public static final IntPtr NULL = new IntPtr();
    public final int[] array;
    public final int offset;

    private IntPtr() {
        this.array = null;
        this.offset = 0;
    }

    public IntPtr(int[] array2, int offset) {
        this.array = array2;
        this.offset = offset;
    }

    public IntPtr(int ... array2) {
        this.array = array2;
        this.offset = 0;
    }

    public static IntPtr malloc(int bytes) {
        return new IntPtr(new int[AbstractPtr.mallocSize(bytes, 4)]);
    }

    public static Ptr toPtr(int i) {
        if (i == 0) {
            return NULL;
        }
        throw new UnsupportedOperationException(String.format("Cannot cast integer %x to pointer", i));
    }

    public static int fromPtr(Ptr ptr) {
        if (ptr.isNull()) {
            return 0;
        }
        return ptr.toInt();
    }

    public int[] getArray() {
        return this.array;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getOffsetInBytes() {
        return this.offset * 4;
    }

    @Override
    public IntPtr realloc(int newSizeInBytes) {
        return new IntPtr(Realloc.realloc(this.array, this.offset, newSizeInBytes / 4));
    }

    public int unwrap() {
        return this.array[this.offset];
    }

    public int get() {
        return this.array[this.offset];
    }

    public void set(int value) {
        this.array[this.offset] = value;
    }

    public String toString() {
        return this.offset + "+" + Arrays.toString(this.array);
    }

    public static void memset(int[] str, int strOffset, int byteValue, int n) {
        assert (n % 4 == 0);
        Arrays.fill(str, strOffset, strOffset + n / 4, IntPtr.memset(byteValue));
    }

    public static int memset(int byteValue) {
        return byteValue << 24 | (byteValue & 0xFF) << 16 | (byteValue & 0xFF) << 8 | byteValue & 0xFF;
    }

    public static int memcmp(IntPtr x, IntPtr y, int n) {
        return IntPtr.memcmp(x.array, x.offset, y.array, y.offset, n);
    }

    public static int memcmp(int[] x, int xi, int[] y, int yi, int n) {
        while (n > 0) {
            int vx = x[xi];
            int vy = y[yi];
            if (vx != vy || n < 4) {
                return IntPtr.memcmp(vx, vy, n);
            }
            ++xi;
            ++yi;
            n -= 4;
        }
        return 0;
    }

    public static int memcmp(int x, int y, int n) {
        for (int i = 0; i < n; ++i) {
            int xb = (int)((long)x & 0xFFL);
            int yb = (int)((long)y & 0xFFL);
            if (xb < yb) {
                return -1;
            }
            if (xb > yb) {
                return 1;
            }
            x >>= 8;
            y >>= 8;
        }
        return 0;
    }

    public static IntPtr cast(Object voidPointer) {
        if (voidPointer instanceof MallocThunk) {
            return ((MallocThunk)voidPointer).intPtr();
        }
        if (voidPointer == null) {
            return NULL;
        }
        return (IntPtr)voidPointer;
    }

    @Override
    public byte getByte(int offset) {
        return this.getByteViaInt(offset);
    }

    @Override
    public int getInt() {
        return this.array[this.offset];
    }

    @Override
    public int getAlignedInt(int index) {
        return this.array[this.offset + index];
    }

    @Override
    public int getInt(int offset) {
        if (this.offset % 4 == 0) {
            return this.array[this.offset + offset / 4];
        }
        return super.getInt(offset);
    }

    @Override
    public void setInt(int value) {
        this.array[this.offset] = value;
    }

    @Override
    public void setInt(int byteOffset, int intValue) {
        if (byteOffset % 4 == 0) {
            this.array[this.offset + byteOffset / 4] = intValue;
        } else {
            super.setInt(byteOffset, intValue);
        }
    }

    @Override
    public void setAlignedInt(int index, int value) {
        this.array[this.offset + index] = value;
    }

    @Override
    public void setByte(int offset, byte value) {
        this.setByteViaInt(offset, value);
    }

    @Override
    public Ptr getPointer(int offset) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public int toInt() {
        return this.offset * 4;
    }

    @Override
    public boolean isNull() {
        return this.array == null && this.offset == 0;
    }

    @Override
    public Ptr pointerPlus(int byteCount) {
        if (byteCount % 4 == 0) {
            return new IntPtr(this.array, this.offset + byteCount / 4);
        }
        return new OffsetPtr(this, byteCount);
    }

    @Deprecated
    public static int unsignedCompare(int a, int b) {
        return Integer.compareUnsigned(a, b);
    }

    public static int unsignedMax(int a, int b) {
        if (Long.compareUnsigned(a, b) > 0) {
            return a;
        }
        return b;
    }

    public static int unsignedMin(int a, int b) {
        if (Long.compareUnsigned(a, b) < 0) {
            return a;
        }
        return b;
    }

    @Deprecated
    public static int unsignedDivide(int dividend, int divisor) {
        return Integer.divideUnsigned(dividend, divisor);
    }

    @Deprecated
    public static int unsignedRemainder(int dividend, int divisor) {
        return Integer.remainderUnsigned(dividend, divisor);
    }

    public static void memcpy(IntPtr x, IntPtr y, int numBytes) {
        int offsetS;
        int[] arrayS = y.getArray();
        int restY = arrayS.length - (offsetS = y.getOffset());
        if (restY > 0) {
            int[] carray = new int[numBytes];
            int i = 0;
            for (int j = offsetS; j < arrayS.length && i < numBytes; ++j, ++i) {
                carray[i] = arrayS[j];
            }
            x = new IntPtr(carray);
        }
    }
}

