/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.util.Arrays;
import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.LongPtr;
import org.renjin.gcc.runtime.MallocThunk;
import org.renjin.gcc.runtime.OffsetPtr;
import org.renjin.gcc.runtime.Ptr;
import org.renjin.gcc.runtime.Realloc;

public class DoublePtr
extends AbstractPtr
implements Ptr {
    public static final DoublePtr NULL = new DoublePtr();
    public static final int BYTES = 8;
    public final double[] array;
    public final int offset;

    private DoublePtr() {
        this.array = null;
        this.offset = 0;
    }

    public DoublePtr(double[] array2, int offset) {
        this.array = array2;
        this.offset = offset;
    }

    public DoublePtr(double ... values) {
        this.array = values;
        this.offset = 0;
    }

    public static DoublePtr malloc(int bytes) {
        return new DoublePtr(new double[AbstractPtr.mallocSize(bytes, 8)]);
    }

    public double[] getArray() {
        return this.array;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getOffsetInBytes() {
        return this.offset * 8;
    }

    @Override
    public DoublePtr realloc(int newSizeInBytes) {
        return new DoublePtr(Realloc.realloc(this.array, this.offset, newSizeInBytes / 8));
    }

    public String toString() {
        return this.offset + "+" + Arrays.toString(this.array);
    }

    public double unwrap() {
        return this.array[this.offset];
    }

    public double get() {
        return this.array[this.offset];
    }

    public double get(int i) {
        return this.array[this.offset + i];
    }

    public void set(double x) {
        this.array[this.offset] = x;
    }

    public void set(int index, double value) {
        this.array[this.offset + index] = value;
    }

    public static int memcmp(DoublePtr x, DoublePtr y, int numBytes) {
        return DoublePtr.memcmp(x.array, x.offset, y.array, y.offset, numBytes);
    }

    public static int memcmp(double[] x, int xi, double[] y, int yi, int n) {
        while (n > 0) {
            long yb;
            long xb = Double.doubleToRawLongBits(xi);
            if (xb != (yb = Double.doubleToRawLongBits(yi)) || n < 8) {
                LongPtr.memcmp(xb, yb, n);
            }
            ++xi;
            ++yi;
            n -= 8;
        }
        return 0;
    }

    public static void memset(double[] str, int strOffset, int c2, int n) {
        assert (n % 8 == 0);
        double doubleValue = DoublePtr.memset(c2);
        Arrays.fill(str, strOffset, strOffset + n / 8, doubleValue);
    }

    public static double memset(int c2) {
        return Double.longBitsToDouble(LongPtr.memset(c2));
    }

    public static DoublePtr cast(Object voidPointer) {
        if (voidPointer instanceof MallocThunk) {
            return ((MallocThunk)voidPointer).doublePtr();
        }
        if (voidPointer == null) {
            return NULL;
        }
        return (DoublePtr)voidPointer;
    }

    @Override
    public void memcpy(Ptr source, int numBytes) {
        int i;
        int numDoubles = numBytes / 8;
        for (i = 0; i < numDoubles; ++i) {
            this.array[this.offset + i] = source.getAlignedDouble(i);
        }
        for (i = numDoubles * 8; i < numBytes; ++i) {
            this.setByte(i, source.getByte(i));
        }
    }

    @Override
    public double getDouble() {
        return this.array[this.offset];
    }

    @Override
    public double getDouble(int offset) {
        if (offset % 8 == 0) {
            return this.array[this.offset + offset / 8];
        }
        return super.getDouble(offset);
    }

    @Override
    public double getAlignedDouble(int index) {
        return this.array[this.offset + index];
    }

    @Override
    public void setDouble(double value) {
        this.array[this.offset] = value;
    }

    @Override
    public void setAlignedDouble(int index, double value) {
        this.array[this.offset + index] = value;
    }

    @Override
    public byte getByte(int offset) {
        return this.getByteViaDouble(offset);
    }

    @Override
    public void setByte(int offset, byte value) {
        this.setByteViaDouble(offset, value);
    }

    @Override
    public int toInt() {
        return this.offset * 8;
    }

    @Override
    public boolean isNull() {
        return this.array == null && this.offset == 0;
    }

    @Override
    public Ptr pointerPlus(int byteCount) {
        if (byteCount % 8 == 0) {
            return new DoublePtr(this.array, this.offset + byteCount / 8);
        }
        return new OffsetPtr(this, byteCount);
    }

    public static void memcpy(DoublePtr x, DoublePtr y, int numBytes) {
        int offsetS;
        double[] arrayS = y.getArray();
        int restY = arrayS.length - (offsetS = y.getOffset());
        if (restY > 0) {
            double[] carray = new double[numBytes];
            int i = 0;
            for (int j = offsetS; j < arrayS.length && i < numBytes; ++j, ++i) {
                carray[i] = arrayS[j];
            }
            x = new DoublePtr(carray);
        }
    }
}

