/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.lang.reflect.Field;
import org.renjin.gcc.runtime.AbstractPtr;
import org.renjin.gcc.runtime.OffsetPtr;
import org.renjin.gcc.runtime.Ptr;

public class DoubleFieldPtr
extends AbstractPtr {
    private final Field field;

    public static Ptr addressOf(Class declaringClass, String fieldName) {
        try {
            return new DoubleFieldPtr(declaringClass.getField(fieldName));
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public DoubleFieldPtr(Field field) {
        this.field = field;
    }

    @Override
    public Object getArray() {
        return this.field;
    }

    @Override
    public final int getOffsetInBytes() {
        return 0;
    }

    @Override
    public Ptr realloc(int newSizeInBytes) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public Ptr pointerPlus(int bytes) {
        if (bytes == 0) {
            return this;
        }
        return new OffsetPtr(this, bytes);
    }

    @Override
    public double getDouble() {
        try {
            return this.field.getDouble(null);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    @Override
    public void setDouble(double value) {
        try {
            this.field.setDouble(null, value);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    @Override
    public double getDouble(int offset) {
        if (offset == 0) {
            return this.getDouble();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setDouble(int offset, double intValue) {
        if (offset != 0) {
            throw new IndexOutOfBoundsException();
        }
        this.setDouble(intValue);
    }

    @Override
    public double getAlignedDouble(int index) {
        if (index == 0) {
            return this.getDouble();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void setAlignedDouble(int index, double value) {
        if (index != 0) {
            throw new IndexOutOfBoundsException();
        }
        this.setDouble(value);
    }

    @Override
    public byte getByte(int offset) {
        return this.getByteViaDouble(offset);
    }

    @Override
    public void setByte(int offset, byte value) {
        this.setByteViaDouble(offset, value);
    }

    @Override
    public int toInt() {
        return 0;
    }

    @Override
    public boolean isNull() {
        return false;
    }
}

