/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.eval;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.renjin.eval.Context;
import org.renjin.eval.FinalizationHandler;
import org.renjin.sexp.SEXP;

public class FinalizerRegistry {
    private final ReferenceQueue<SEXP> queue = new ReferenceQueue();
    private final Set<Finalizer> finalizers = new HashSet<Finalizer>();

    public void register(SEXP sexp2, FinalizationHandler handler, boolean onExit) {
        this.finalizers.add(new Finalizer(sexp2, handler, onExit));
    }

    public void finalizeDisposedEnvironments(Context context) {
        Reference<SEXP> ref;
        while ((ref = this.queue.poll()) != null) {
            Finalizer finalizer2 = (Finalizer)ref;
            this.finalizers.remove(finalizer2);
            finalizer2.invoke(context);
        }
    }

    public void finalizeOnExit(Context context) {
        ArrayList<Finalizer> toInvoke = new ArrayList<Finalizer>(this.finalizers);
        this.finalizers.clear();
        for (Finalizer finalizer2 : toInvoke) {
            if (!finalizer2.isOnExit()) continue;
            finalizer2.invoke(context);
        }
    }

    private class Finalizer
    extends WeakReference<SEXP> {
        private final FinalizationHandler function;
        private boolean onExit;

        public Finalizer(SEXP sexp2, FinalizationHandler function2, boolean onExit) {
            super(sexp2, FinalizerRegistry.this.queue);
            this.function = function2;
            this.onExit = onExit;
        }

        private void invoke(Context context) {
            this.function.finalizeSexp(context, (SEXP)this.get());
        }

        public SEXP getSexp() {
            SEXP e = (SEXP)this.get();
            if (e == null) {
                throw new IllegalStateException("Environment has already been garbage collected!");
            }
            return e;
        }

        public boolean isOnExit() {
            return this.onExit;
        }
    }
}

