/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.eval;

import java.util.Collections;
import java.util.Map;
import org.renjin.eval.ArgumentMatcher;
import org.renjin.eval.Calls;
import org.renjin.eval.ConditionException;
import org.renjin.eval.Context;
import org.renjin.eval.DispatchChain;
import org.renjin.eval.EvalException;
import org.renjin.eval.MatchedArguments;
import org.renjin.eval.RestartException;
import org.renjin.primitives.special.ReturnException;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Promise;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class ClosureDispatcher {
    private final FunctionCall call;
    private final Environment callingEnvironment;
    private final Context callingContext;
    private DispatchChain dispatchChain;

    public ClosureDispatcher(Context callingContext, Environment callingEnvironment, FunctionCall call2) {
        this.call = call2;
        this.callingEnvironment = callingEnvironment;
        this.callingContext = callingContext;
    }

    public SEXP apply(DispatchChain chain, PairList arguments) {
        this.dispatchChain = chain;
        return ClosureDispatcher.apply(this.callingContext, this.callingEnvironment, this.call, chain.getClosure(), arguments, this.dispatchChain.createMetadata());
    }

    public SEXP applyClosure(Closure closure, PairList args2) {
        PairList promisedArgs = Calls.promiseArgs(args2, this.callingContext, this.callingEnvironment);
        return ClosureDispatcher.apply(this.callingContext, this.callingEnvironment, this.call, closure, promisedArgs, Collections.emptyMap());
    }

    public static SEXP apply(Context callingContext, Environment callingEnvironment, FunctionCall call2, Closure closure, PairList promisedArgs, Map<Symbol, SEXP> metadata) {
        Context functionContext = callingContext.beginFunction(callingEnvironment, call2, closure, promisedArgs);
        Environment functionEnvironment = functionContext.getEnvironment();
        try {
            ClosureDispatcher.matchArgumentsInto(closure.getFormals(), promisedArgs, functionEnvironment);
            if (!metadata.isEmpty()) {
                for (Map.Entry sEXP : metadata.entrySet()) {
                    functionEnvironment.setVariableUnsafe((Symbol)sEXP.getKey(), (SEXP)sEXP.getValue());
                }
            }
            try {
                SEXP sEXP = closure.doApply(functionContext);
                return sEXP;
            }
            catch (EvalException e) {
                try {
                    e.initContext(functionContext);
                    throw e;
                }
                catch (ReturnException e2) {
                    if (e2.getEnvironment() != functionEnvironment) {
                        throw e2;
                    }
                    SEXP sEXP = e2.getValue();
                    return sEXP;
                }
                catch (ConditionException e3) {
                    if (e3.getHandlerContext() == functionContext) {
                        ListVector listVector = new ListVector(e3.getCondition(), Null.INSTANCE, e3.getHandler());
                        return listVector;
                    }
                    throw e3;
                }
                catch (RestartException e4) {
                    if (e4.getExitEnvironment() == functionContext.getEnvironment()) {
                        ListVector listVector = e4.getArguments();
                        return listVector;
                    }
                    throw e4;
                }
            }
        }
        finally {
            functionContext.exit();
        }
    }

    public static void matchArgumentsInto(PairList formals2, PairList actuals, Environment functionEnv) {
        ArgumentMatcher matcher = new ArgumentMatcher(formals2);
        MatchedArguments matching = matcher.match(actuals);
        for (int formalIndex = 0; formalIndex < matching.getFormalCount(); ++formalIndex) {
            if (matching.isFormalEllipses(formalIndex)) {
                functionEnv.setVariableUnsafe(Symbols.ELLIPSES, (SEXP)matching.buildExtraArgumentList());
                continue;
            }
            Symbol formalName = matching.getFormalName(formalIndex);
            int actualIndex = matching.getActualIndex(formalIndex);
            if (actualIndex == -1) {
                SEXP defaultValue = matcher.getDefaultValue(formalIndex);
                functionEnv.setMissingArgument(formalName, ClosureDispatcher.promiseDefaultValue(functionEnv, defaultValue));
                continue;
            }
            SEXP actualValue = matching.getActualValue(actualIndex);
            if (actualValue == Symbol.MISSING_ARG) {
                SEXP defaultValue = matcher.getDefaultValue(formalIndex);
                functionEnv.setMissingArgument(formalName, ClosureDispatcher.promiseDefaultValue(functionEnv, defaultValue));
                continue;
            }
            functionEnv.setArgument(formalName, actualValue);
        }
    }

    private static SEXP promiseDefaultValue(Environment functionEnv, SEXP defaultValue) {
        if (defaultValue != Symbol.MISSING_ARG) {
            defaultValue = Promise.repromise(functionEnv, defaultValue);
        }
        return defaultValue;
    }

    public static PairList matchArguments(PairList formals2, PairList actuals) {
        return ClosureDispatcher.matchArguments(formals2, actuals, true);
    }

    public static PairList matchArguments(PairList formals2, PairList actuals, boolean populateMissing) {
        ArgumentMatcher matcher = new ArgumentMatcher(formals2);
        MatchedArguments matching = matcher.match(actuals);
        PairList.Builder result = new PairList.Builder();
        for (int formalIndex = 0; formalIndex < matching.getFormalCount(); ++formalIndex) {
            if (matching.isFormalEllipses(formalIndex)) {
                result.add(Symbols.ELLIPSES, (SEXP)matching.buildExtraArgumentList());
                continue;
            }
            int actualIndex = matching.getActualIndex(formalIndex);
            if (actualIndex == -1) {
                if (!populateMissing) continue;
                result.add(matching.getFormalName(formalIndex), (SEXP)Symbol.MISSING_ARG);
                continue;
            }
            result.add(matching.getFormalName(formalIndex), matching.getActualValue(actualIndex));
        }
        return result.build();
    }
}

