/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.statements;

import java.util.Arrays;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.NullExpression;
import org.renjin.compiler.ir.tac.statements.BasicBlockEndingStatement;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.compiler.ir.tac.statements.StatementVisitor;
import org.renjin.repackaged.asm.commons.InstructionAdapter;

public class GotoStatement
implements Statement,
BasicBlockEndingStatement {
    private final IRLabel target;

    public GotoStatement(IRLabel target) {
        this.target = target;
    }

    public IRLabel getTarget() {
        return this.target;
    }

    @Override
    public Iterable<IRLabel> possibleTargets() {
        return Arrays.asList(this.target);
    }

    public String toString() {
        return "goto " + this.target;
    }

    @Override
    public Expression getRHS() {
        return NullExpression.INSTANCE;
    }

    @Override
    public void setRHS(Expression newRHS) {
        if (newRHS != NullExpression.INSTANCE) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void setChild(int childIndex, Expression child) {
        throw new IllegalArgumentException();
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public Expression childAt(int index) {
        throw new IllegalArgumentException();
    }

    @Override
    public void accept(StatementVisitor visitor) {
        visitor.visitGoto(this);
    }

    @Override
    public int emit(EmitContext emitContext, InstructionAdapter mv) {
        mv.visitJumpInsn(167, emitContext.getAsmLabel(this.target));
        return 0;
    }

    @Override
    public boolean isPure() {
        return true;
    }
}

