/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.functions;

import java.util.Map;
import org.renjin.compiler.NotCompilableException;
import org.renjin.compiler.ir.tac.functions.AndTranslator;
import org.renjin.compiler.ir.tac.functions.AssignLeftTranslator;
import org.renjin.compiler.ir.tac.functions.AssignTranslator;
import org.renjin.compiler.ir.tac.functions.BracketTranslator;
import org.renjin.compiler.ir.tac.functions.BreakTranslator;
import org.renjin.compiler.ir.tac.functions.BuiltinTranslator;
import org.renjin.compiler.ir.tac.functions.ClosureCallTranslator;
import org.renjin.compiler.ir.tac.functions.ClosureTranslator;
import org.renjin.compiler.ir.tac.functions.DollarAssignTranslator;
import org.renjin.compiler.ir.tac.functions.DollarTranslator;
import org.renjin.compiler.ir.tac.functions.ForTranslator;
import org.renjin.compiler.ir.tac.functions.FunctionCallTranslator;
import org.renjin.compiler.ir.tac.functions.IfTranslator;
import org.renjin.compiler.ir.tac.functions.InternalCallTranslator;
import org.renjin.compiler.ir.tac.functions.NextTranslator;
import org.renjin.compiler.ir.tac.functions.OrTranslator;
import org.renjin.compiler.ir.tac.functions.ParenTranslator;
import org.renjin.compiler.ir.tac.functions.QuoteTranslator;
import org.renjin.compiler.ir.tac.functions.ReassignLeftTranslator;
import org.renjin.compiler.ir.tac.functions.RepeatTranslator;
import org.renjin.compiler.ir.tac.functions.ReturnTranslator;
import org.renjin.compiler.ir.tac.functions.SequenceTranslator;
import org.renjin.compiler.ir.tac.functions.SlotTranslator;
import org.renjin.compiler.ir.tac.functions.SwitchTranslator;
import org.renjin.compiler.ir.tac.functions.UseMethodTranslator;
import org.renjin.compiler.ir.tac.functions.WhileTranslator;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Function;
import org.renjin.sexp.PrimitiveFunction;

public class FunctionCallTranslators {
    private Map<String, FunctionCallTranslator> specials = Maps.newHashMap();
    private Map<String, FunctionCallTranslator> builtins = Maps.newHashMap();

    public FunctionCallTranslators() {
        this.specials.put("if", new IfTranslator());
        this.specials.put("{", new BracketTranslator());
        this.specials.put("(", new ParenTranslator());
        this.specials.put("<-", new AssignLeftTranslator());
        this.specials.put("<<-", new ReassignLeftTranslator());
        this.specials.put("=", new AssignTranslator());
        this.specials.put("for", new ForTranslator());
        this.specials.put("repeat", new RepeatTranslator());
        this.specials.put("while", new WhileTranslator());
        this.specials.put("next", new NextTranslator());
        this.specials.put("break", new BreakTranslator());
        this.specials.put("function", new ClosureTranslator());
        this.specials.put("$", new DollarTranslator());
        this.specials.put("$<-", new DollarAssignTranslator());
        this.specials.put(".Internal", new InternalCallTranslator());
        this.specials.put("&&", new AndTranslator());
        this.specials.put("||", new OrTranslator());
        this.specials.put("switch", new SwitchTranslator());
        this.specials.put("quote", new QuoteTranslator());
        this.specials.put("return", new ReturnTranslator());
        this.specials.put(":", new SequenceTranslator());
        this.specials.put("UseMethod", new UseMethodTranslator());
        this.specials.put("@", new SlotTranslator());
    }

    public FunctionCallTranslator get(Function function2) {
        if (function2 instanceof PrimitiveFunction) {
            PrimitiveFunction primitiveFunction = (PrimitiveFunction)function2;
            if (this.specials.containsKey(primitiveFunction.getName())) {
                return this.specials.get(primitiveFunction.getName());
            }
            return BuiltinTranslator.INSTANCE;
        }
        if (function2 instanceof Closure) {
            return new ClosureCallTranslator((Closure)function2);
        }
        throw new NotCompilableException(function2, "Can't handle functions of class " + function2.getClass().getName());
    }
}

