/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.expressions;

import java.util.Map;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.sexp.Symbol;

public class NamedSlotAccess
implements Expression {
    private Expression expression;
    private Symbol slot;
    private ValueBounds valueBounds;

    public NamedSlotAccess(Expression expression2, String slot) {
        this.expression = expression2;
        this.slot = Symbol.get(slot);
        this.valueBounds = ValueBounds.UNBOUNDED;
    }

    @Override
    public boolean isPure() {
        return true;
    }

    @Override
    public int load(EmitContext emitContext, InstructionAdapter mv) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ValueBounds updateTypeBounds(Map<Expression, ValueBounds> typeMap) {
        ValueBounds object2 = typeMap.get(this.expression);
        if (!object2.isAttributeConstant(this.slot)) {
            throw new UnsupportedOperationException("TODO: ");
        }
        this.valueBounds = ValueBounds.of(object2.getAttributeIfConstant(this.slot));
        return this.valueBounds;
    }

    @Override
    public Type getType() {
        return this.valueBounds.storageType();
    }

    @Override
    public ValueBounds getValueBounds() {
        return this.valueBounds;
    }

    @Override
    public void setChild(int childIndex, Expression child) {
        if (childIndex != 0) {
            throw new IllegalArgumentException("childIndex:" + childIndex);
        }
        this.expression = child;
    }

    @Override
    public int getChildCount() {
        return 1;
    }

    @Override
    public Expression childAt(int index) {
        return this.expression;
    }

    public String toString() {
        return this.expression + "@" + this.slot;
    }
}

