/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.ssa;

import org.renjin.compiler.ir.IRFormatting;
import org.renjin.compiler.ir.tac.expressions.Variable;

public class SsaVariable
extends Variable {
    private final Variable inner;
    private final int version;

    public SsaVariable(Variable inner, int version) {
        if (inner instanceof SsaVariable) {
            throw new IllegalArgumentException("SSA variables should not be nested");
        }
        this.inner = inner;
        this.version = version;
    }

    public Variable getInner() {
        return this.inner;
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean isPure() {
        return this.version != 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.inner.toString());
        IRFormatting.appendSubscript(sb, this.version);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.inner.hashCode();
        result = 31 * result + this.version;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SsaVariable other = (SsaVariable)obj;
        return this.inner.equals(other.inner) && this.version == other.version;
    }
}

