/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.codegen;

import java.util.Map;
import org.renjin.compiler.TypeSolver;
import org.renjin.compiler.cfg.BasicBlock;
import org.renjin.compiler.cfg.ControlFlowGraph;
import org.renjin.compiler.codegen.InlineEmitContext;
import org.renjin.compiler.codegen.VariableSlots;
import org.renjin.compiler.codegen.VariableStorage;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.LValue;
import org.renjin.compiler.ir.tac.statements.Assignment;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.repackaged.asm.Label;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.repackaged.guava.collect.HashMultimap;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.repackaged.guava.collect.Multimap;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;

public class EmitContext {
    private Map<IRLabel, Label> labels = Maps.newHashMap();
    private Multimap<LValue, Expression> definitionMap = HashMultimap.create();
    private int paramSize;
    private VariableSlots variableSlots;
    private int loopVectorIndex;
    private int loopIterationIndex;
    private int maxInlineVariables;

    public EmitContext(ControlFlowGraph cfg, int paramSize, VariableSlots variableSlots) {
        this.paramSize = paramSize;
        this.variableSlots = variableSlots;
        this.buildDefinitionMap(cfg);
    }

    public int getContextVarIndex() {
        return 1;
    }

    public int getEnvironmentVarIndex() {
        return 2;
    }

    private void buildDefinitionMap(ControlFlowGraph cfg) {
        for (BasicBlock bb : cfg.getBasicBlocks()) {
            for (Statement stmt : bb.getStatements()) {
                if (!(stmt instanceof Assignment)) continue;
                Assignment assignment = (Assignment)stmt;
                this.definitionMap.put(assignment.getLHS(), assignment.getRHS());
            }
        }
    }

    public Label getAsmLabel(IRLabel irLabel) {
        Label asmLabel = this.labels.get(irLabel);
        if (asmLabel == null) {
            asmLabel = new Label();
            this.labels.put(irLabel, asmLabel);
        }
        return asmLabel;
    }

    public InlineEmitContext inlineContext(ControlFlowGraph cfg, TypeSolver types) {
        VariableSlots childSlots = new VariableSlots(this.paramSize + this.variableSlots.getNumLocals(), types);
        if (childSlots.getNumLocals() > this.maxInlineVariables) {
            this.maxInlineVariables = childSlots.getNumLocals();
        }
        return new InlineEmitContext(cfg, this.paramSize + this.variableSlots.getNumLocals(), childSlots);
    }

    public int getLoopVectorIndex() {
        return this.loopVectorIndex;
    }

    public void setLoopVectorIndex(int loopVectorIndex) {
        this.loopVectorIndex = loopVectorIndex;
    }

    public int getLoopIterationIndex() {
        return this.loopIterationIndex;
    }

    public void setLoopIterationIndex(int loopIterationIndex) {
        this.loopIterationIndex = loopIterationIndex;
    }

    public int getRegister(LValue lValue) {
        return this.variableSlots.getSlot(lValue);
    }

    public int convert(InstructionAdapter mv, Type fromType, Type toType) {
        if (fromType.equals(Type.getType(DoubleArrayVector.class))) {
            fromType = Type.getType(DoubleVector.class);
        }
        if (fromType.equals(toType)) {
            return 0;
        }
        if (fromType.getSort() != 10 && toType.getSort() != 10) {
            mv.cast(fromType, toType);
            return 0;
        }
        if (fromType.equals(Type.getType(SEXP.class)) || fromType.equals(Type.getType(DoubleVector.class))) {
            if (toType.getSort() == 10) {
                mv.checkcast(toType);
                return 0;
            }
            if (toType.equals(Type.DOUBLE_TYPE)) {
                mv.invokeinterface(Type.getInternalName(SEXP.class), "asReal", Type.getMethodDescriptor(Type.DOUBLE_TYPE, new Type[0]));
                return 0;
            }
            if (toType.equals(Type.INT_TYPE)) {
                mv.checkcast(Type.getType(Vector.class));
                mv.iconst(0);
                mv.invokeinterface(Type.getInternalName(Vector.class), "getElementAsInt", Type.getMethodDescriptor(Type.INT_TYPE, Type.INT_TYPE));
                return 1;
            }
        } else if (toType.equals(Type.getType(AtomicVector.class))) {
            if (fromType.equals(Type.getType(DoubleVector.class))) {
                return 0;
            }
        } else if (toType.equals(Type.getType(SEXP.class))) {
            if (fromType.getSort() == 10) {
                return 0;
            }
            switch (fromType.getSort()) {
                case 5: {
                    return this.box(mv, IntVector.class, Type.INT_TYPE);
                }
                case 8: {
                    return this.box(mv, DoubleVector.class, Type.DOUBLE_TYPE);
                }
            }
        }
        throw new UnsupportedOperationException("Unsupported conversion: " + fromType + " -> " + toType);
    }

    private int box(InstructionAdapter mv, Class vectorClass, Type primitiveType) {
        mv.invokestatic(Type.getInternalName(vectorClass), "valueOf", Type.getMethodDescriptor(Type.getType(vectorClass), primitiveType), false);
        return 0;
    }

    public VariableStorage getVariableStorage(LValue lhs) {
        return this.variableSlots.getStorage(lhs);
    }

    public int getLocalVariableCount() {
        return this.paramSize + this.variableSlots.getNumLocals();
    }

    public void writeReturn(InstructionAdapter mv, Type returnType) {
        mv.areturn(returnType);
    }

    public void writeDone(InstructionAdapter mv) {
    }

    public void loadParam(InstructionAdapter mv, Symbol param) {
        throw new IllegalStateException();
    }
}

