/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.builtins;

import java.util.List;
import java.util.Map;
import org.renjin.compiler.builtins.ArgumentBounds;
import org.renjin.compiler.builtins.FailedToSpecializeException;
import org.renjin.compiler.builtins.Specialization;
import org.renjin.compiler.builtins.UnspecializedCall;
import org.renjin.compiler.cfg.InlinedFunction;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.compiler.ir.tac.RuntimeState;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.eval.MatchedArgumentPositions;
import org.renjin.primitives.S3;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Function;
import org.renjin.sexp.StringVector;

public class S3Specialization
implements Specialization {
    private RuntimeState runtimeState;
    private Closure closure;
    private InlinedFunction inlinedMethod = null;
    private MatchedArgumentPositions matchedArguments;
    private Type type;
    private ValueBounds returnBounds;

    public S3Specialization(RuntimeState runtimeState, Closure closure, List<ArgumentBounds> arguments) {
        this.runtimeState = runtimeState;
        this.closure = closure;
        this.updateTypeBounds(closure, arguments);
    }

    public S3Specialization(RuntimeState runtimeState, Closure closure, Map<Expression, ValueBounds> typeMap, List<IRArgument> arguments) {
        this(runtimeState, closure, ArgumentBounds.create(arguments, typeMap));
    }

    private void updateTypeBounds(Closure function2, List<ArgumentBounds> arguments) {
        if (this.inlinedMethod == null || this.inlinedMethod.getClosure() != function2) {
            this.matchedArguments = MatchedArgumentPositions.matchArgumentBounds(this.closure, arguments);
            this.inlinedMethod = new InlinedFunction(this.runtimeState, this.closure, this.matchedArguments.getSuppliedFormals());
        }
        if (this.matchedArguments.hasExtraArguments()) {
            throw new FailedToSpecializeException("Extra arguments not supported");
        }
        this.returnBounds = this.inlinedMethod.updateBounds(arguments);
        this.type = this.returnBounds.storageType();
    }

    public static Specialization trySpecialize(String generic, RuntimeState runtimeState, ValueBounds objectExpr, List<ArgumentBounds> arguments) {
        StringVector objectClass = S3.computeDataClasses(objectExpr);
        if (objectClass == null) {
            return UnspecializedCall.INSTANCE;
        }
        Function function2 = runtimeState.findMethod(generic, null, objectClass);
        if (function2 instanceof Closure) {
            return new S3Specialization(runtimeState, (Closure)function2, arguments);
        }
        return UnspecializedCall.INSTANCE;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public ValueBounds getResultBounds() {
        return this.returnBounds;
    }

    @Override
    public void load(EmitContext emitContext, InstructionAdapter mv, List<IRArgument> arguments) {
        if (this.inlinedMethod == null) {
            throw new FailedToSpecializeException("Could not resolve S3 method");
        }
        if (this.matchedArguments.hasExtraArguments()) {
            throw new FailedToSpecializeException("Extra arguments not supported");
        }
        this.inlinedMethod.writeInline(emitContext, mv, this.matchedArguments, arguments);
    }

    @Override
    public boolean isPure() {
        if (this.inlinedMethod == null) {
            return false;
        }
        return this.inlinedMethod.isPure();
    }
}

