/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.builtins;

import java.util.List;
import org.renjin.compiler.builtins.Specialization;
import org.renjin.compiler.codegen.EmitContext;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.tac.IRArgument;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.repackaged.asm.Type;
import org.renjin.repackaged.asm.commons.InstructionAdapter;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;

public class GetListElement
implements Specialization {
    private ValueBounds source;
    private ValueBounds index;
    private ValueBounds element;

    public GetListElement(ValueBounds source, ValueBounds index) {
        this.source = source;
        this.index = index;
        this.element = source.getElementBounds();
    }

    @Override
    public Type getType() {
        return Type.getType(SEXP.class);
    }

    @Override
    public ValueBounds getResultBounds() {
        return this.element;
    }

    @Override
    public void load(EmitContext emitContext, InstructionAdapter mv, List<IRArgument> arguments) {
        Expression sourceArgument = arguments.get(0).getExpression();
        sourceArgument.load(emitContext, mv);
        emitContext.convert(mv, sourceArgument.getType(), Type.getType(ListVector.class));
        Expression indexArgument = arguments.get(0).getExpression();
        indexArgument.load(emitContext, mv);
        emitContext.convert(mv, indexArgument.getType(), Type.INT_TYPE);
        mv.invokeinterface(Type.getInternalName(SEXP.class), "getElementAsSEXP", Type.getMethodDescriptor(Type.getType(SEXP.class), Type.INT_TYPE));
    }

    @Override
    public boolean isPure() {
        return true;
    }
}

