/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.renjin.compiler.NotCompilableException;
import org.renjin.compiler.cfg.BasicBlock;
import org.renjin.compiler.cfg.ControlFlowGraph;
import org.renjin.compiler.cfg.FlowEdge;
import org.renjin.compiler.cfg.SsaEdge;
import org.renjin.compiler.cfg.UseDefMap;
import org.renjin.compiler.ir.ValueBounds;
import org.renjin.compiler.ir.exception.InvalidSyntaxException;
import org.renjin.compiler.ir.ssa.PhiFunction;
import org.renjin.compiler.ir.ssa.SsaVariable;
import org.renjin.compiler.ir.tac.RuntimeState;
import org.renjin.compiler.ir.tac.expressions.EnvironmentVariable;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.LValue;
import org.renjin.compiler.ir.tac.expressions.NullExpression;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.compiler.ir.tac.statements.Assignment;
import org.renjin.compiler.ir.tac.statements.IfStatement;
import org.renjin.compiler.ir.tac.statements.Statement;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.sexp.Function;
import org.renjin.sexp.Logical;
import org.renjin.sexp.Symbol;

public class TypeSolver {
    private final ControlFlowGraph cfg;
    private UseDefMap useDefMap;
    private final ArrayDeque<FlowEdge> flowWorkList = new ArrayDeque();
    private final ArrayDeque<SsaEdge> ssaWorkList = new ArrayDeque();
    private static final ValueBounds TOP = null;
    private final Map<Expression, ValueBounds> variableBounds = Maps.newHashMap();
    private final Map<IfStatement, ValueBounds> conditionalBounds = Maps.newHashMap();
    private final Set<FlowEdge> executable = Sets.newHashSet();

    public TypeSolver(ControlFlowGraph cfg, UseDefMap useDefMap) {
        this.cfg = cfg;
        this.useDefMap = useDefMap;
    }

    public boolean isDefined(LValue variable) {
        return this.useDefMap.isDefined(variable);
    }

    public boolean isUsed(Assignment assignment) {
        return this.isUsed(assignment.getLHS());
    }

    public boolean isUsed(LValue variable) {
        return this.useDefMap.isUsed(variable);
    }

    public Map<LValue, ValueBounds> getVariables() {
        HashMap<LValue, ValueBounds> map = new HashMap<LValue, ValueBounds>();
        for (LValue variable : this.useDefMap.getUsedVariables()) {
            map.put(variable, this.variableBounds.get(variable));
        }
        return map;
    }

    public void execute() {
        this.executable.clear();
        for (BasicBlock basicBlock : this.cfg.getBasicBlocks()) {
            basicBlock.setLive(false);
        }
        this.conditionalBounds.clear();
        this.flowWorkList.clear();
        this.ssaWorkList.clear();
        for (FlowEdge flowEdge : this.cfg.getEntry().getOutgoing()) {
            if (flowEdge.getSuccessor() == this.cfg.getExit()) continue;
            this.flowWorkList.add(flowEdge);
        }
        while (!this.flowWorkList.isEmpty() || !this.ssaWorkList.isEmpty()) {
            Object edge;
            while (!this.flowWorkList.isEmpty()) {
                edge = this.flowWorkList.pop();
                if (this.executable.contains(edge)) continue;
                BasicBlock node = ((FlowEdge)edge).getSuccessor();
                node.setLive(true);
                this.executable.add((FlowEdge)edge);
                for (Assignment phiAssignment : node.phiAssignments()) {
                    this.visitPhi(phiAssignment);
                }
                if (this.countIncomingExecutableEdges(node) == 1) {
                    for (Statement statement : node.getStatements()) {
                        if (statement.getRHS() == NullExpression.INSTANCE || statement.getRHS() instanceof PhiFunction) continue;
                        this.visitExpression(node, statement);
                    }
                }
                if (node.getOutgoing().size() != 1) continue;
                this.flowWorkList.addAll(node.getOutgoing());
            }
            while (!this.ssaWorkList.isEmpty()) {
                edge = this.ssaWorkList.pop();
                if (((SsaEdge)edge).isPhiFunction()) {
                    this.visitPhi((Assignment)((SsaEdge)edge).getDestinationStatement());
                    continue;
                }
                if (this.countIncomingExecutableEdges(((SsaEdge)edge).getDestinationNode()) <= 0) continue;
                this.visitExpression(((SsaEdge)edge).getDestinationNode(), ((SsaEdge)edge).getDestinationStatement());
            }
        }
    }

    private void visitPhi(Assignment assignment) {
        PhiFunction phiFunction = (PhiFunction)assignment.getRHS();
        ArrayList<ValueBounds> boundSet = new ArrayList<ValueBounds>();
        for (int i = 0; i < phiFunction.getIncomingEdges().size(); ++i) {
            Variable ssaVariable;
            ValueBounds value;
            FlowEdge incomingEdge = phiFunction.getIncomingEdges().get(i);
            if (!this.executable.contains(incomingEdge) || (value = this.variableBounds.get(ssaVariable = phiFunction.getArgument(i))) == TOP) continue;
            boundSet.add(value);
        }
        if (!boundSet.isEmpty()) {
            this.maybeUpdateLhs(assignment, ValueBounds.union(boundSet));
        }
    }

    public void dumpBounds() {
        for (Expression expression2 : this.variableBounds.keySet()) {
            if (!(expression2 instanceof LValue)) continue;
            System.out.println(expression2 + " => " + this.variableBounds.get(expression2));
        }
    }

    public boolean isPure() {
        HashSet<BasicBlock> checked = Sets.newHashSet();
        for (FlowEdge flowEdge : this.executable) {
            BasicBlock basicBlock = flowEdge.getSuccessor();
            if (!checked.add(basicBlock) || basicBlock.isPure()) continue;
            return false;
        }
        return true;
    }

    private void visitExpression(BasicBlock block, Statement statement) {
        IfStatement conditional;
        ValueBounds oldBounds;
        Expression expression2 = statement.getRHS();
        ValueBounds newBounds = expression2.updateTypeBounds(this.variableBounds);
        if (statement instanceof Assignment) {
            this.maybeUpdateLhs((Assignment)statement, newBounds);
        }
        if (statement instanceof IfStatement && !Objects.equals(oldBounds = this.conditionalBounds.get(conditional = (IfStatement)statement), newBounds)) {
            this.conditionalBounds.put(conditional, newBounds);
            if (newBounds.isConstant()) {
                Logical conditionValue = newBounds.getConstantValue().asLogical();
                if (conditionValue == Logical.NA) {
                    throw new InvalidSyntaxException("missing value where TRUE/FALSE needed");
                }
                conditional.setConstantValue(conditionValue);
                if (conditionValue == Logical.TRUE) {
                    this.flowWorkList.add(block.getOutgoing(conditional.getTrueTarget()));
                } else {
                    this.flowWorkList.add(block.getOutgoing(conditional.getFalseTarget()));
                }
            } else {
                conditional.setConstantValue(null);
                this.flowWorkList.add(block.getOutgoing(conditional.getTrueTarget()));
                this.flowWorkList.add(block.getOutgoing(conditional.getFalseTarget()));
            }
        }
    }

    private void maybeUpdateLhs(Assignment assignment, ValueBounds newBounds) {
        ValueBounds oldBounds = this.variableBounds.put(assignment.getLHS(), newBounds);
        if (!Objects.equals(oldBounds, newBounds)) {
            assignment.getLHS().update(newBounds);
            this.variableBounds.put(assignment.getLHS(), newBounds);
            Collection<SsaEdge> outgoingEdges = this.useDefMap.getSsaEdges(assignment.getLHS());
            this.ssaWorkList.addAll(outgoingEdges);
        }
    }

    public int countIncomingExecutableEdges(BasicBlock block) {
        int count = 0;
        for (FlowEdge flowEdge : block.getIncoming()) {
            if (!this.executable.contains(flowEdge)) continue;
            ++count;
        }
        return count;
    }

    public void verifyFunctionAssumptions(RuntimeState runtimeState) {
        Map<Symbol, Function> resolvedFunctions = runtimeState.getResolvedFunctions();
        for (Map.Entry<Expression, ValueBounds> entry : this.variableBounds.entrySet()) {
            EnvironmentVariable variable;
            SsaVariable lhs;
            if (!(entry.getKey() instanceof SsaVariable) || !((lhs = (SsaVariable)entry.getKey()).getInner() instanceof EnvironmentVariable) || !resolvedFunctions.containsKey((variable = (EnvironmentVariable)lhs.getInner()).getName())) continue;
            Function resolvedFunction = resolvedFunctions.get(variable.getName());
            this.checkPotentialFunctionAssignment(variable, entry.getValue(), resolvedFunction);
        }
    }

    private void checkPotentialFunctionAssignment(EnvironmentVariable variable, ValueBounds bounds, Function resolvedFunction) {
        if ((bounds.getTypeSet() & 0x400) == 0) {
            return;
        }
        if (bounds.isConstant() && bounds.getConstantValue() == resolvedFunction) {
            return;
        }
        throw new NotCompilableException(variable.getName(), "change to function definition");
    }
}

