/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.info;

import java.io.File;
import java.util.Iterator;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.AbstractCommand;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.command.info.SvnInfoScmResult;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.apache.maven.scm.provider.svn.svnexe.command.info.SvnInfoConsumer;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class SvnInfoCommand
extends AbstractCommand
implements SvnCommand {
    protected ScmResult executeCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        return this.executeInfoCommand((SvnScmProviderRepository)repository, fileSet, parameters, false, null);
    }

    public SvnInfoScmResult executeInfoCommand(SvnScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters, boolean recursive2, String revision) throws ScmException {
        int exitCode;
        Commandline cl = SvnInfoCommand.createCommandLine(repository, fileSet, recursive2, revision);
        SvnInfoConsumer consumer = new SvnInfoConsumer();
        CommandLineUtils.StringStreamConsumer stderr2 = new CommandLineUtils.StringStreamConsumer();
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Executing: " + SvnCommandLineUtils.cryptPassword(cl));
            this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        }
        try {
            exitCode = SvnCommandLineUtils.execute(cl, consumer, stderr2, this.getLogger());
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", ex);
        }
        if (exitCode != 0) {
            return new SvnInfoScmResult(cl.toString(), "The svn command failed.", stderr2.getOutput(), false);
        }
        return new SvnInfoScmResult(cl.toString(), consumer.getInfoItems());
    }

    protected static Commandline createCommandLine(SvnScmProviderRepository repository, ScmFileSet fileSet, boolean recursive2, String revision) {
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(fileSet.getBasedir(), repository);
        cl.createArg().setValue("info");
        if (recursive2) {
            cl.createArg().setValue("--recursive");
        }
        if (StringUtils.isNotEmpty(revision)) {
            cl.createArg().setValue("-r");
            cl.createArg().setValue(revision);
        }
        Iterator it = fileSet.getFileList().iterator();
        while (it.hasNext()) {
            File file2 = (File)it.next();
            if (repository == null) {
                cl.createArg().setValue(file2.getPath());
                continue;
            }
            cl.createArg().setValue(repository.getUrl() + "/" + file2.getPath().replace('\\', '/'));
        }
        return cl;
    }
}

