/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process.reflect;

import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.preflight.PreflightConfiguration;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.content.PreflightContentStream;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelper;
import org.apache.pdfbox.preflight.graphic.ColorSpaceHelperFactory;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.COSUtils;
import org.apache.pdfbox.preflight.utils.ContextHelper;

public class SinglePageValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext context) throws ValidationException {
        PreflightPath vPath = context.getValidationPath();
        if (vPath.isEmpty()) {
            return;
        }
        if (!vPath.isExpectedType(PDPage.class)) {
            this.addValidationError(context, new ValidationResult.ValidationError("8.1", "Page validation required at least a PDPage"));
        } else {
            PDPage page = (PDPage)vPath.peek();
            this.validateActions(context, page);
            this.validateAnnotation(context, page);
            this.validateColorSpaces(context, page);
            this.validateResources(context, page);
            this.validateGraphicObjects(context, page);
            this.validateGroupTransparency(context, page);
            this.validateContent(context, page);
        }
    }

    protected void validateActions(PreflightContext context, PDPage page) throws ValidationException {
        ContextHelper.validateElement(context, page.getCOSObject(), "actions-process");
    }

    protected void validateColorSpaces(PreflightContext context, PDPage page) {
        PDResources resources = page.getResources();
        if (resources != null) {
            PreflightConfiguration config = context.getConfig();
            ColorSpaceHelperFactory colorSpaceFactory = config.getColorSpaceHelperFact();
            for (COSName name : resources.getColorSpaceNames()) {
                try {
                    PDColorSpace pdCS = resources.getColorSpace(name);
                    ColorSpaceHelper csHelper = colorSpaceFactory.getColorSpaceHelper(context, pdCS, ColorSpaceHelperFactory.ColorSpaceRestriction.NO_RESTRICTION);
                    csHelper.validate();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void validateGraphicObjects(PreflightContext context, PDPage page) throws ValidationException {
        COSBase thumbBase = page.getCOSObject().getItem("Thumb");
        if (thumbBase != null) {
            try {
                if (thumbBase instanceof COSObject) {
                    thumbBase = ((COSObject)thumbBase).getObject();
                }
                PDImageXObject thumbImg = PDImageXObject.createThumbnail((COSStream)((COSStream)thumbBase));
                ContextHelper.validateElement(context, thumbImg, "graphic-process");
            }
            catch (IOException e) {
                context.addValidationError(new ValidationResult.ValidationError("2.1", "Unable to read Thumb image : " + e.getMessage()));
            }
        }
    }

    protected void validateResources(PreflightContext context, PDPage page) throws ValidationException {
        ContextHelper.validateElement(context, page.getResources(), "resources-process");
    }

    protected void validateContent(PreflightContext context, PDPage page) throws ValidationException {
        try {
            PreflightContentStream csWrapper = new PreflightContentStream(context, page);
            csWrapper.validatePageContentStream();
        }
        catch (IOException e) {
            context.addValidationError(new ValidationResult.ValidationError("-1", e.getMessage(), e));
        }
    }

    protected void validateAnnotation(PreflightContext context, PDPage page) throws ValidationException {
        try {
            List lAnnots = page.getAnnotations();
            for (Object object : lAnnots) {
                if (!(object instanceof PDAnnotation)) continue;
                COSDictionary cosAnnot = ((PDAnnotation)object).getCOSObject();
                ContextHelper.validateElement(context, cosAnnot, "annotations-process");
            }
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ValidationException("Unable to access Annotation", e);
        }
    }

    protected void validateGroupTransparency(PreflightContext context, PDPage page) throws ValidationException {
        String sVal;
        COSBase baseGroup = page.getCOSObject().getItem("Group");
        COSDictionary groupDictionary = COSUtils.getAsDictionary(baseGroup, context.getDocument().getDocument());
        if (groupDictionary != null && "Transparency".equals(sVal = groupDictionary.getNameAsString(COSName.S))) {
            context.addValidationError(new ValidationResult.ValidationError("2.2.1", "Group has a transparency S entry or the S entry is null"));
        }
    }
}

