/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.hibernate;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;

public class HibernateConnectionProvider
implements ConnectionProvider {
    private String url;
    private Properties connectionProps;
    private Integer isolation;
    private final ArrayList<Connection> pool = new ArrayList();
    private int poolSize;
    private int checkedOut = 0;
    private boolean autocommit;
    private Driver driver;
    private static final Log log = LogFactory.getLog(HibernateConnectionProvider.class);

    public void configure(Properties props) throws HibernateException {
        String driverClass = props.getProperty("hibernate.connection.driver_class");
        this.poolSize = PropertiesHelper.getInt((String)"hibernate.connection.pool_size", (Properties)props, (int)20);
        log.info((Object)"Using Hibernate built-in connection pool (not for production use!)");
        log.info((Object)("Hibernate connection pool size: " + this.poolSize));
        this.autocommit = PropertiesHelper.getBoolean((String)"hibernate.connection.autocommit", (Properties)props);
        log.info((Object)("autocommit mode: " + this.autocommit));
        this.isolation = PropertiesHelper.getInteger((String)"hibernate.connection.isolation", (Properties)props);
        if (this.isolation != null) {
            log.info((Object)("JDBC isolation level: " + Environment.isolationLevelToString((int)this.isolation)));
        }
        if (driverClass == null) {
            log.warn((Object)"no JDBC Driver class was specified by property hibernate.connection.driver_class");
        } else {
            try {
                this.driver = (Driver)Class.forName(driverClass, true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (Exception e) {
                try {
                    this.driver = (Driver)ReflectHelper.classForName((String)driverClass).newInstance();
                }
                catch (Exception e1) {
                    log.error((Object)e1.getMessage());
                    throw new HibernateException((Throwable)e1);
                }
            }
        }
        this.url = props.getProperty("hibernate.connection.url");
        if (this.url == null) {
            String msg = "JDBC URL was not specified by property hibernate.connection.url";
            log.error((Object)msg);
            throw new HibernateException(msg);
        }
        this.connectionProps = ConnectionProviderFactory.getConnectionProperties((Properties)props);
        log.info((Object)("using driver: " + driverClass + " at URL: " + this.url));
        if (log.isDebugEnabled()) {
            log.info((Object)("connection properties: " + this.connectionProps));
        } else if (log.isInfoEnabled()) {
            log.info((Object)("connection properties: " + PropertiesHelper.maskOut((Properties)this.connectionProps, (String)"password")));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("total checked-out connections: " + this.checkedOut));
        }
        ArrayList<Connection> arrayList = this.pool;
        synchronized (arrayList) {
            if (!this.pool.isEmpty()) {
                int last = this.pool.size() - 1;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("using pooled JDBC connection, pool size: " + last));
                    ++this.checkedOut;
                }
                Connection pooled = this.pool.remove(last);
                if (this.isolation != null) {
                    pooled.setTransactionIsolation(this.isolation);
                }
                if (pooled.getAutoCommit() != this.autocommit) {
                    pooled.setAutoCommit(this.autocommit);
                }
                return pooled;
            }
        }
        log.debug((Object)"opening new JDBC connection");
        Connection conn = this.driver.connect(this.url, this.connectionProps);
        if (this.isolation != null) {
            conn.setTransactionIsolation(this.isolation);
        }
        if (conn.getAutoCommit() != this.autocommit) {
            conn.setAutoCommit(this.autocommit);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("created connection to: " + this.url + ", Isolation Level: " + conn.getTransactionIsolation()));
        }
        if (log.isTraceEnabled()) {
            ++this.checkedOut;
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(Connection conn) throws SQLException {
        if (log.isDebugEnabled()) {
            --this.checkedOut;
        }
        ArrayList<Connection> arrayList = this.pool;
        synchronized (arrayList) {
            int currentSize = this.pool.size();
            if (currentSize < this.poolSize) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("returning connection to pool, pool size: " + (currentSize + 1)));
                }
                this.pool.add(conn);
                return;
            }
        }
        log.debug((Object)"closing JDBC connection");
        conn.close();
    }

    public void close() {
        log.info((Object)("cleaning up connection pool: " + this.url));
        Iterator<Connection> iter = this.pool.iterator();
        while (iter.hasNext()) {
            try {
                iter.next().close();
            }
            catch (SQLException sqle) {
                log.warn((Object)"problem closing pooled connection", (Throwable)sqle);
            }
        }
        this.pool.clear();
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }
}

