/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.webservice.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.sys.ShiroLoginSupport;
import com.netsteadfast.greenstep.util.SystemExpressionJobUtils;
import com.netsteadfast.greenstep.vo.SysExprJobLogVO;
import com.netsteadfast.greenstep.webservice.IManualJobService;
import java.util.Map;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.shiro.subject.Subject;
import org.springframework.stereotype.Service;

@Service(value="core.webservice.ManualJobService")
@WebService
@Path(value="/")
@Produces(value={"application/json"})
public class ManualJobServiceImpl
implements IManualJobService {
    protected static Logger log = Logger.getLogger(ManualJobServiceImpl.class);

    @Override
    @WebMethod
    @POST
    @Path(value="/executeJob/{uploadOid}")
    public String execute(@WebParam(name="uploadOid") @PathParam(value="uploadOid") String uploadOid) throws Exception {
        ObjectMapper objectMapper;
        SysExprJobLogVO result;
        block20: {
            String exceptionMessage;
            block21: {
                Map<String, Object> dataMap;
                Subject subject;
                block18: {
                    String string;
                    block19: {
                        result = null;
                        subject = null;
                        objectMapper = new ObjectMapper();
                        exceptionMessage = "";
                        dataMap = SystemExpressionJobUtils.getDecUploadOid(uploadOid);
                        if (dataMap != null && !StringUtils.isBlank((String)dataMap.get("accountId")) && !StringUtils.isBlank((String)dataMap.get("sysExprJobOid"))) break block18;
                        log.error("no data accountId / sysExprJobOid");
                        result = new SysExprJobLogVO();
                        result.setFaultMsg("no data accountId / sysExprJobOid");
                        string = objectMapper.writeValueAsString(result);
                        if (result != null) break block19;
                        result = new SysExprJobLogVO();
                    }
                    if (subject != null) {
                        subject.logout();
                    }
                    if (!StringUtils.isBlank(exceptionMessage) && StringUtils.isBlank(result.getFaultMsg())) {
                        result.setFaultMsg(exceptionMessage);
                    }
                    return string;
                }
                try {
                    String accountId = (String)dataMap.get("accountId");
                    String sysExprJobOid = (String)dataMap.get("sysExprJobOid");
                    ShiroLoginSupport loginSupport = new ShiroLoginSupport();
                    subject = loginSupport.forceCreateLoginSubject(accountId);
                    result = SystemExpressionJobUtils.executeJobForManual(sysExprJobOid);
                }
                catch (ServiceException se) {
                    se.printStackTrace();
                    exceptionMessage = se.getMessage().toString();
                    if (result == null) {
                        result = new SysExprJobLogVO();
                    }
                    if (subject != null) {
                        subject.logout();
                    }
                    if (!StringUtils.isBlank(exceptionMessage) && StringUtils.isBlank(result.getFaultMsg())) {
                        result.setFaultMsg(exceptionMessage);
                    }
                    break block20;
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        exceptionMessage = e.getMessage() == null ? e.toString() : e.getMessage().toString();
                        break block20;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (result == null) {
                            result = new SysExprJobLogVO();
                        }
                        if (subject != null) {
                            subject.logout();
                        }
                        if (!StringUtils.isBlank(exceptionMessage) && StringUtils.isBlank(result.getFaultMsg())) {
                            result.setFaultMsg(exceptionMessage);
                        }
                    }
                }
                if (result == null) {
                    result = new SysExprJobLogVO();
                }
                if (subject == null) break block21;
                subject.logout();
            }
            if (!StringUtils.isBlank(exceptionMessage) && StringUtils.isBlank(result.getFaultMsg())) {
                result.setFaultMsg(exceptionMessage);
            }
        }
        return objectMapper.writeValueAsString(result);
    }
}

