/*
 * Decompiled with CFR 0.152.
 */
package com.netsteadfast.greenstep.util;

import com.netsteadfast.greenstep.base.AppContext;
import com.netsteadfast.greenstep.base.Constants;
import com.netsteadfast.greenstep.base.exception.ServiceException;
import com.netsteadfast.greenstep.base.model.DefaultResult;
import com.netsteadfast.greenstep.po.hbm.TbSysUpload;
import com.netsteadfast.greenstep.po.hbm.TbSysUploadTran;
import com.netsteadfast.greenstep.po.hbm.TbSysUploadTranSegm;
import com.netsteadfast.greenstep.service.ISysUploadService;
import com.netsteadfast.greenstep.service.ISysUploadTranSegmService;
import com.netsteadfast.greenstep.service.ISysUploadTranService;
import com.netsteadfast.greenstep.util.FSUtils;
import com.netsteadfast.greenstep.util.ScriptExpressionUtils;
import com.netsteadfast.greenstep.util.SimpleUtils;
import com.netsteadfast.greenstep.vo.SysUploadTranSegmVO;
import com.netsteadfast.greenstep.vo.SysUploadTranVO;
import com.netsteadfast.greenstep.vo.SysUploadVO;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class UploadSupportUtils {
    protected static Logger logger = Logger.getLogger(UploadSupportUtils.class);
    public static final String HELP_EXPRESSION_VARIABLE = "datas";
    private static Properties props = new Properties();
    private static String[] VIEW_MODE_FILE_EXTENSION = null;
    private static ISysUploadService<SysUploadVO, TbSysUpload, String> sysUploadService = (ISysUploadService)AppContext.getBean("core.service.SysUploadService");
    private static ISysUploadTranService<SysUploadTranVO, TbSysUploadTran, String> sysUploadTranService = (ISysUploadTranService)AppContext.getBean("core.service.SysUploadTranService");
    private static ISysUploadTranSegmService<SysUploadTranSegmVO, TbSysUploadTranSegm, String> sysUploadTranSegmService = (ISysUploadTranSegmService)AppContext.getBean("core.service.SysUploadTranSegmService");

    static {
        try {
            props.load(UploadSupportUtils.class.getClassLoader().getResource("META-INF/view-mode-files.properties").openStream());
            VIEW_MODE_FILE_EXTENSION = SimpleUtils.getStr(props.getProperty("FILE_EXTENSION")).trim().split(",");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getViewMode(String fileShowName) throws Exception {
        String viewMode = "N";
        String fileExtensionName = StringUtils.defaultString(UploadSupportUtils.getFileExtensionName(fileShowName)).trim().toLowerCase();
        int i = 0;
        while (VIEW_MODE_FILE_EXTENSION != null && i < VIEW_MODE_FILE_EXTENSION.length) {
            if (VIEW_MODE_FILE_EXTENSION[i].toLowerCase().equals(fileExtensionName)) {
                viewMode = "Y";
            }
            ++i;
        }
        return viewMode;
    }

    public static SysUploadTranVO findSysUploadTran(String tranId) throws ServiceException, Exception {
        SysUploadTranVO tran = new SysUploadTranVO();
        tran.setTranId(tranId);
        DefaultResult<SysUploadTranVO> result = sysUploadTranService.findByUK(tran);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        tran = result.getValue();
        return tran;
    }

    public static List<TbSysUploadTranSegm> findSysUploadTranSegm(String tranId) throws ServiceException, Exception {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("tranId", tranId);
        return sysUploadTranSegmService.findListByParams(paramMap);
    }

    public static List<Map<String, String>> getTransformSegmentData(String uploadOid, String tranId) throws ServiceException, Exception {
        LinkedList<Map<String, String>> datas = new LinkedList<Map<String, String>>();
        File file = UploadSupportUtils.getRealFile(uploadOid);
        SysUploadTranVO tran = UploadSupportUtils.findSysUploadTran(tranId);
        List<TbSysUploadTranSegm> segms = UploadSupportUtils.findSysUploadTranSegm(tran.getTranId());
        List<String> txtLines = FileUtils.readLines(file, tran.getEncoding());
        int i = 0;
        while (i < txtLines.size()) {
            String str = txtLines.get(i);
            if (str.length() < 1) {
                logger.warn("The file: " + file.getPath() + " found zero line.");
            } else if (i >= tran.getBeginLen()) {
                datas.add(UploadSupportUtils.fillDataMap(tran, segms, str));
            }
            ++i;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put(HELP_EXPRESSION_VARIABLE, datas);
        ScriptExpressionUtils.execute(tran.getExprType(), tran.getHelpExpression(), null, paramMap);
        return datas;
    }

    public Object getTransformObjectData(String uploadOid, Class<?> classesToBeBound) throws ServiceException, Exception {
        Object result = null;
        byte[] xmlBytes = UploadSupportUtils.getDataBytes(uploadOid);
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{classesToBeBound});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        result = jaxbUnmarshaller.unmarshal((InputStream)new ByteArrayInputStream(xmlBytes));
        return result;
    }

    public static void cleanTempUpload() throws ServiceException, Exception {
        UploadSupportUtils.cleanTempUpload(Constants.getSystem());
    }

    public static void cleanTempUpload(String system) throws ServiceException, Exception {
        logger.info("clean upload(" + system + ") temp begin...");
        sysUploadService.deleteTmpContent(system);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("system", system);
        params.put("type", "tmp");
        params.put("isFile", "Y");
        List searchList = sysUploadService.findListByParams(params);
        int i = 0;
        while (searchList != null && i < searchList.size()) {
            TbSysUpload entity = (TbSysUpload)searchList.get(i);
            String dir = UploadSupportUtils.getUploadFileDir(entity.getSystem(), entity.getSubDir(), entity.getType());
            String fileFullPath = String.valueOf(dir) + "/" + entity.getFileName();
            File file = new File(fileFullPath);
            if (!file.exists()) {
                file = null;
            } else {
                try {
                    logger.warn("delete : " + file.getPath());
                    FileUtils.forceDelete(file);
                    sysUploadService.delete(entity);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        logger.info("end...");
    }

    public static String getSubDir() {
        return SimpleUtils.getStrYMD(1);
    }

    public static String getUploadFileDir(String system, String type) {
        return UploadSupportUtils.getUploadFileDir(system, UploadSupportUtils.getSubDir(), type);
    }

    public static String getUploadFileDir(String system, String subDir, String type) {
        if (StringUtils.isBlank(system) || StringUtils.isBlank(subDir) || StringUtils.isBlank(type)) {
            throw new IllegalArgumentException("system, sub-dir and type cann't blank!");
        }
        return String.valueOf(Constants.getUploadDir()) + "/" + system + "/" + type + "/" + subDir + "/";
    }

    public static File mkdirUploadFileDir(String system, String type) throws IOException, Exception {
        return UploadSupportUtils.mkdirUploadFileDir(system, UploadSupportUtils.getSubDir(), type);
    }

    public static File mkdirUploadFileDir(String system, String subDir, String type) throws IOException, Exception {
        String uploadDir = UploadSupportUtils.getUploadFileDir(system, subDir, type);
        File dir = new File(uploadDir);
        if (dir.exists() && dir.isDirectory()) {
            return dir;
        }
        FileUtils.forceMkdir(dir);
        return dir;
    }

    public static String generateRealFileName(String showName) {
        if (StringUtils.isBlank(showName)) {
            throw new IllegalArgumentException("name is blank!");
        }
        String extension = UploadSupportUtils.getFileExtensionName(showName);
        if (StringUtils.isBlank(extension)) {
            return SimpleUtils.getUUIDStr();
        }
        if (extension.length() > 13) {
            extension = extension.substring(0, 13);
        }
        return String.valueOf(SimpleUtils.getUUIDStr()) + "." + extension;
    }

    public static String generateRealFileName(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file is null!");
        }
        return UploadSupportUtils.generateRealFileName(file.getName());
    }

    public static File getRealFile(String uploadOid) throws ServiceException, IOException, Exception {
        File packageFile;
        SysUploadVO uploadObj;
        block10: {
            if (StringUtils.isBlank(uploadOid)) {
                throw new Exception("parameter is blank!");
            }
            uploadObj = UploadSupportUtils.findUpload(uploadOid);
            packageFile = null;
            if (!"Y".equals(uploadObj.getIsFile())) {
                File dir = new File(String.valueOf(Constants.getWorkTmpDir()) + "/" + UploadSupportUtils.class.getSimpleName());
                if (!dir.exists() || !dir.isDirectory()) {
                    FileUtils.forceMkdir(dir);
                }
                String tmpFileName = String.valueOf(dir.getPath()) + "/" + SimpleUtils.getUUIDStr() + "." + UploadSupportUtils.getFileExtensionName(uploadObj.getShowName());
                dir = null;
                OutputStream fos = null;
                try {
                    packageFile = new File(tmpFileName);
                    fos = new FileOutputStream(packageFile);
                    IOUtils.write(uploadObj.getContent(), fos);
                    fos.flush();
                    break block10;
                }
                finally {
                    if (fos != null) {
                        fos.close();
                    }
                    fos = null;
                }
            }
            String uploadDir = UploadSupportUtils.getUploadFileDir(uploadObj.getSystem(), uploadObj.getSubDir(), uploadObj.getType());
            packageFile = new File(String.valueOf(uploadDir) + "/" + uploadObj.getFileName());
        }
        if (!packageFile.exists()) {
            throw new Exception("File is missing: " + uploadObj.getFileName());
        }
        return packageFile;
    }

    public static byte[] getDataBytes(String uploadOid) throws ServiceException, IOException, Exception {
        if (StringUtils.isBlank(uploadOid)) {
            throw new Exception("parameter is blank!");
        }
        byte[] datas = null;
        SysUploadVO uploadObj = UploadSupportUtils.findUpload(uploadOid);
        datas = uploadObj.getContent();
        if ("Y".equals(uploadObj.getIsFile())) {
            String uploadDir = UploadSupportUtils.getUploadFileDir(uploadObj.getSystem(), uploadObj.getSubDir(), uploadObj.getType());
            File file = new File(String.valueOf(uploadDir) + "/" + uploadObj.getFileName());
            datas = FileUtils.readFileToByteArray(file);
            file = null;
        }
        return datas;
    }

    public static DefaultResult<Boolean> updateType(String oid, String type) throws ServiceException, IOException, Exception {
        DefaultResult<SysUploadVO> uploadResult = sysUploadService.findForNoByteContent(oid);
        if (uploadResult.getValue() == null) {
            throw new ServiceException(uploadResult.getSystemMessage().getValue());
        }
        SysUploadVO upload = uploadResult.getValue();
        if (!"Y".equals(upload.getIsFile())) {
            return sysUploadService.updateTypeOnly(oid, type);
        }
        DefaultResult<Boolean> result = sysUploadService.updateTypeOnly(oid, type);
        if (result.getValue() == null || !result.getValue().booleanValue()) {
            return result;
        }
        String oldFullPath = String.valueOf(UploadSupportUtils.getUploadFileDir(upload.getSystem(), upload.getSubDir(), upload.getType())) + upload.getFileName();
        String newFullPath = String.valueOf(UploadSupportUtils.getUploadFileDir(upload.getSystem(), upload.getSubDir(), type)) + upload.getFileName();
        File newFile = new File(newFullPath);
        if (newFile.isFile() && newFile.exists()) {
            newFile = null;
            throw new Exception("error. file exists, cannot operate!");
        }
        newFile = null;
        File oldFile = new File(oldFullPath);
        if (!oldFile.exists()) {
            oldFile = null;
            throw new Exception("error. file no exists: " + oldFullPath);
        }
        oldFile = null;
        FSUtils.mv(oldFullPath, newFullPath);
        return result;
    }

    public static String create(String system, String type, boolean isFile, File file, String showName) throws ServiceException, IOException, Exception {
        if (StringUtils.isBlank(type) || file == null || StringUtils.isBlank(showName)) {
            throw new Exception("parameter is blank!");
        }
        if (!file.exists()) {
            throw new Exception("file no exists!");
        }
        SysUploadVO upload = new SysUploadVO();
        upload.setIsFile(isFile ? "Y" : "N");
        upload.setShowName(showName);
        upload.setSystem(system);
        upload.setType(type);
        upload.setSubDir(UploadSupportUtils.getSubDir());
        if (isFile) {
            String uploadDir = UploadSupportUtils.getUploadFileDir(system, type);
            String uploadFileName = UploadSupportUtils.generateRealFileName(file);
            UploadSupportUtils.mkdirUploadFileDir(system, type);
            FSUtils.cp(file.getPath(), String.valueOf(uploadDir) + "/" + uploadFileName);
            upload.setFileName(uploadFileName);
        } else {
            upload.setContent(FileUtils.readFileToByteArray(file));
            upload.setFileName(" ");
        }
        DefaultResult<SysUploadVO> result = sysUploadService.saveObject(upload);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        return result.getValue().getOid();
    }

    public static String create(String system, String type, boolean isFile, byte[] datas, String showName) throws ServiceException, IOException, Exception {
        if (StringUtils.isBlank(type) || datas == null || StringUtils.isBlank(showName)) {
            throw new Exception("parameter is blank!");
        }
        SysUploadVO upload = new SysUploadVO();
        upload.setIsFile(isFile ? "Y" : "N");
        upload.setShowName(showName);
        upload.setSystem(system);
        upload.setType(type);
        upload.setSubDir(UploadSupportUtils.getSubDir());
        if (isFile) {
            String uploadDir = UploadSupportUtils.getUploadFileDir(system, type);
            String uploadFileName = UploadSupportUtils.generateRealFileName(showName);
            UploadSupportUtils.mkdirUploadFileDir(system, type);
            File file = null;
            try {
                file = new File(String.valueOf(uploadDir) + "/" + uploadFileName);
                FileUtils.writeByteArrayToFile(file, datas);
            }
            finally {
                file = null;
            }
            upload.setFileName(uploadFileName);
        } else {
            upload.setContent(datas);
            upload.setFileName(" ");
        }
        DefaultResult<SysUploadVO> result = sysUploadService.saveObject(upload);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        return result.getValue().getOid();
    }

    public static String getFileExtensionName(String fileFullName) {
        if (StringUtils.isBlank(fileFullName)) {
            return "";
        }
        String extension = "";
        String[] tmp = fileFullName.split("[.]");
        int i = 1;
        while (tmp != null && i < tmp.length) {
            extension = tmp[i];
            ++i;
        }
        return extension;
    }

    public static SysUploadVO findUpload(String uploadOid) throws ServiceException, Exception {
        if (StringUtils.isBlank(uploadOid)) {
            throw new Exception("Upload OID parameter is blank!");
        }
        SysUploadVO uploadObj = new SysUploadVO();
        uploadObj.setOid(uploadOid);
        DefaultResult<SysUploadVO> result = sysUploadService.findObjectByOid(uploadObj);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().getValue());
        }
        uploadObj = result.getValue();
        return uploadObj;
    }

    public static SysUploadVO findUploadNoByteContent(String uploadOid) throws ServiceException, Exception {
        if (StringUtils.isBlank(uploadOid)) {
            throw new Exception("Upload OID parameter is blank!");
        }
        DefaultResult<SysUploadVO> result = sysUploadService.findForNoByteContent(uploadOid);
        if (result.getValue() == null) {
            throw new ServiceException(result.getSystemMessage().toString());
        }
        return result.getValue();
    }

    private static Map<String, String> fillDataMap(SysUploadTranVO tran, List<TbSysUploadTranSegm> segms, String strLine) throws Exception {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if ("TEXT".equals(tran.getSegmMode())) {
            for (TbSysUploadTranSegm segm : segms) {
                if (strLine.length() < segm.getEnd()) {
                    throw new Exception("data format error.");
                }
                dataMap.put(segm.getName(), strLine.substring(segm.getBegin(), segm.getEnd()));
            }
        } else if ("BYTE".equals(tran.getSegmMode())) {
            byte[] dataBytes = strLine.getBytes(tran.getEncoding());
            for (TbSysUploadTranSegm segm : segms) {
                if (dataBytes.length < segm.getEnd()) {
                    throw new Exception("data format error.");
                }
                String dataStr = new String(ArrayUtils.subarray(dataBytes, segm.getBegin(), segm.getEnd()), tran.getEncoding());
                dataMap.put(segm.getName(), dataStr);
            }
        } else {
            String[] tmpStr = strLine.split(tran.getSegmSymbol());
            for (TbSysUploadTranSegm segm : segms) {
                if (segm.getBegin() != segm.getEnd()) {
                    throw new Exception("segment config begin/end error.");
                }
                if (tmpStr == null || tmpStr.length < segm.getBegin()) {
                    throw new Exception("data format error.");
                }
                dataMap.put(segm.getName(), tmpStr[segm.getBegin()]);
            }
        }
        return dataMap;
    }
}

